/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockPriority;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class LruCachedBlock
implements HeapSize,
Comparable<LruCachedBlock> {
    public static final long PER_BLOCK_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 24 + ClassSize.STRING + ClassSize.BYTE_BUFFER);
    private final BlockCacheKey cacheKey;
    private final Cacheable buf;
    private volatile long accessTime;
    private long size;
    private BlockPriority priority;
    private final long cachedTime = System.nanoTime();

    public LruCachedBlock(BlockCacheKey cacheKey, Cacheable buf, long accessTime) {
        this(cacheKey, buf, accessTime, false);
    }

    public LruCachedBlock(BlockCacheKey cacheKey, Cacheable buf, long accessTime, boolean inMemory) {
        this.cacheKey = cacheKey;
        this.buf = buf;
        this.accessTime = accessTime;
        this.size = ClassSize.align(cacheKey.heapSize()) + ClassSize.align(buf.heapSize()) + PER_BLOCK_OVERHEAD;
        this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.SINGLE;
    }

    public void access(long accessTime) {
        this.accessTime = accessTime;
        if (this.priority == BlockPriority.SINGLE) {
            this.priority = BlockPriority.MULTI;
        }
    }

    public long getCachedTime() {
        return this.cachedTime;
    }

    @Override
    public long heapSize() {
        return this.size;
    }

    @Override
    public int compareTo(LruCachedBlock that) {
        if (this.accessTime == that.accessTime) {
            return 0;
        }
        return this.accessTime < that.accessTime ? 1 : -1;
    }

    public int hashCode() {
        return (int)(this.accessTime ^ this.accessTime >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LruCachedBlock other = (LruCachedBlock)obj;
        return this.compareTo(other) == 0;
    }

    public Cacheable getBuffer() {
        return this.buf;
    }

    public BlockCacheKey getCacheKey() {
        return this.cacheKey;
    }

    public BlockPriority getPriority() {
        return this.priority;
    }
}

