/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.protobuf;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.com.google.protobuf.ByteString;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.UserPermission;

@InterfaceAudience.Private
public final class ResponseConverter {
    private static final Log LOG = LogFactory.getLog(ResponseConverter.class);

    private ResponseConverter() {
    }

    public static MultiResponse getResults(ClientProtos.MultiRequest request, ClientProtos.MultiResponse response, CellScanner cells) throws IOException {
        int responseRegionActionResultCount;
        int requestRegionActionCount = request.getRegionActionCount();
        if (requestRegionActionCount != (responseRegionActionResultCount = response.getRegionActionResultCount())) {
            throw new IllegalStateException("Request mutation count=" + responseRegionActionResultCount + " does not match response mutation result count=" + responseRegionActionResultCount);
        }
        MultiResponse results = new MultiResponse();
        for (int i = 0; i < responseRegionActionResultCount; ++i) {
            ClientProtos.RegionAction actions = request.getRegionAction(i);
            ClientProtos.RegionActionResult actionResult = response.getRegionActionResult(i);
            HBaseProtos.RegionSpecifier rs = actions.getRegion();
            if (rs.hasType() && rs.getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                throw new IllegalArgumentException("We support only encoded types for protobuf multi response.");
            }
            byte[] regionName = rs.getValue().toByteArray();
            if (actionResult.hasException()) {
                Throwable regionException = ProtobufUtil.toException(actionResult.getException());
                results.addException(regionName, regionException);
                continue;
            }
            if (actions.getActionCount() != actionResult.getResultOrExceptionCount()) {
                throw new IllegalStateException("actions.getActionCount=" + actions.getActionCount() + ", actionResult.getResultOrExceptionCount=" + actionResult.getResultOrExceptionCount() + " for region " + actions.getRegion());
            }
            for (ClientProtos.ResultOrException roe : actionResult.getResultOrExceptionList()) {
                Object responseValue;
                if (roe.hasException()) {
                    responseValue = ProtobufUtil.toException(roe.getException());
                } else if (roe.hasResult()) {
                    responseValue = ProtobufUtil.toResult(roe.getResult(), cells);
                    if (roe.hasLoadStats()) {
                        ((Result)responseValue).addResults(roe.getLoadStats());
                    }
                } else if (roe.hasServiceResult()) {
                    responseValue = roe.getServiceResult();
                } else {
                    throw new IllegalStateException("No result & no exception roe=" + roe + " for region " + actions.getRegion());
                }
                results.add(regionName, roe.getIndex(), responseValue);
            }
        }
        return results;
    }

    public static ClientProtos.ResultOrException.Builder buildActionResult(Throwable t) {
        ClientProtos.ResultOrException.Builder builder = ClientProtos.ResultOrException.newBuilder();
        if (t != null) {
            builder.setException(ResponseConverter.buildException(t));
        }
        return builder;
    }

    public static ClientProtos.ResultOrException.Builder buildActionResult(ClientProtos.Result r, ClientProtos.RegionLoadStats stats) {
        ClientProtos.ResultOrException.Builder builder = ClientProtos.ResultOrException.newBuilder();
        if (r != null) {
            builder.setResult(r);
        }
        if (stats != null) {
            builder.setLoadStats(stats);
        }
        return builder;
    }

    public static HBaseProtos.NameBytesPair buildException(Throwable t) {
        HBaseProtos.NameBytesPair.Builder parameterBuilder = HBaseProtos.NameBytesPair.newBuilder();
        parameterBuilder.setName(t.getClass().getName());
        parameterBuilder.setValue(ByteString.copyFromUtf8(StringUtils.stringifyException((Throwable)t)));
        return parameterBuilder.build();
    }

    public static AccessControlProtos.GetUserPermissionsResponse buildGetUserPermissionsResponse(List<UserPermission> permissions) {
        AccessControlProtos.GetUserPermissionsResponse.Builder builder = AccessControlProtos.GetUserPermissionsResponse.newBuilder();
        for (UserPermission perm : permissions) {
            builder.addUserPermission(ProtobufUtil.toUserPermission(perm));
        }
        return builder.build();
    }

    public static List<HRegionInfo> getRegionInfos(AdminProtos.GetOnlineRegionResponse proto) {
        if (proto == null || proto.getRegionInfoCount() == 0) {
            return null;
        }
        return ProtobufUtil.getRegionInfos(proto);
    }

    public static RegionOpeningState getRegionOpeningState(AdminProtos.OpenRegionResponse proto) {
        if (proto == null || proto.getOpeningStateCount() != 1) {
            return null;
        }
        return RegionOpeningState.valueOf(proto.getOpeningState(0).name());
    }

    public static List<RegionOpeningState> getRegionOpeningStateList(AdminProtos.OpenRegionResponse proto) {
        if (proto == null) {
            return null;
        }
        ArrayList<RegionOpeningState> regionOpeningStates = new ArrayList<RegionOpeningState>();
        for (int i = 0; i < proto.getOpeningStateCount(); ++i) {
            regionOpeningStates.add(RegionOpeningState.valueOf(proto.getOpeningState(i).name()));
        }
        return regionOpeningStates;
    }

    public static boolean isClosed(AdminProtos.CloseRegionResponse proto) {
        if (proto == null || !proto.hasClosed()) {
            return false;
        }
        return proto.getClosed();
    }

    public static AdminProtos.GetServerInfoResponse buildGetServerInfoResponse(ServerName serverName, int webuiPort) {
        AdminProtos.GetServerInfoResponse.Builder builder = AdminProtos.GetServerInfoResponse.newBuilder();
        AdminProtos.ServerInfo.Builder serverInfoBuilder = AdminProtos.ServerInfo.newBuilder();
        serverInfoBuilder.setServerName(ProtobufUtil.toServerName(serverName));
        if (webuiPort >= 0) {
            serverInfoBuilder.setWebuiPort(webuiPort);
        }
        builder.setServerInfo(serverInfoBuilder.build());
        return builder.build();
    }

    public static AdminProtos.GetOnlineRegionResponse buildGetOnlineRegionResponse(List<HRegionInfo> regions) {
        AdminProtos.GetOnlineRegionResponse.Builder builder = AdminProtos.GetOnlineRegionResponse.newBuilder();
        for (HRegionInfo region : regions) {
            builder.addRegionInfo(HRegionInfo.convert(region));
        }
        return builder.build();
    }

    public static MasterProtos.RunCatalogScanResponse buildRunCatalogScanResponse(int numCleaned) {
        return MasterProtos.RunCatalogScanResponse.newBuilder().setScanResult(numCleaned).build();
    }

    public static MasterProtos.EnableCatalogJanitorResponse buildEnableCatalogJanitorResponse(boolean prevValue) {
        return MasterProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(prevValue).build();
    }

    public static RegionServerStatusProtos.GetLastFlushedSequenceIdResponse buildGetLastFlushedSequenceIdResponse(ClusterStatusProtos.RegionStoreSequenceIds ids) {
        return RegionServerStatusProtos.GetLastFlushedSequenceIdResponse.newBuilder().setLastFlushedSequenceId(ids.getLastFlushedSequenceId()).addAllStoreLastFlushedSequenceId(ids.getStoreSequenceIdList()).build();
    }

    public static void setControllerException(RpcController controller, IOException ioe) {
        if (controller != null) {
            if (controller instanceof ServerRpcController) {
                ((ServerRpcController)controller).setFailedOn(ioe);
            } else {
                controller.setFailed(StringUtils.stringifyException((Throwable)ioe));
            }
        }
    }

    @Nullable
    public static IOException getControllerException(RpcController controller) throws IOException {
        if (controller != null && controller.failed()) {
            if (controller instanceof ServerRpcController) {
                return ((ServerRpcController)controller).getFailedOn();
            }
            return new DoNotRetryIOException(controller.errorText());
        }
        return null;
    }

    public static Result[] getResults(CellScanner cellScanner, ClientProtos.ScanResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        int noOfResults = cellScanner != null ? response.getCellsPerResultCount() : response.getResultsCount();
        Result[] results = new Result[noOfResults];
        for (int i = 0; i < noOfResults; ++i) {
            if (cellScanner != null) {
                int noOfCells = response.getCellsPerResult(i);
                boolean isPartial = response.getPartialFlagPerResultCount() > i ? response.getPartialFlagPerResult(i) : false;
                ArrayList<Cell> cells = new ArrayList<Cell>(noOfCells);
                for (int j = 0; j < noOfCells; ++j) {
                    try {
                        if (!cellScanner.advance()) {
                            String msg = "Results sent from server=" + noOfResults + ". But only got " + i + " results completely at client. Resetting the scanner to scan again.";
                            LOG.error((Object)msg);
                            throw new DoNotRetryIOException(msg);
                        }
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)"Exception while reading cells from result.Resetting the scanner to scan again.", (Throwable)ioe);
                        throw new DoNotRetryIOException("Resetting the scanner.", ioe);
                    }
                    cells.add(cellScanner.current());
                }
                results[i] = Result.create(cells, null, response.getStale(), isPartial);
                continue;
            }
            results[i] = ProtobufUtil.toResult(response.getResults(i));
        }
        return results;
    }

    public static Map<String, Long> getScanMetrics(ClientProtos.ScanResponse response) {
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        if (response == null || !response.hasScanMetrics() || response.getScanMetrics() == null) {
            return metricMap;
        }
        MapReduceProtos.ScanMetrics metrics = response.getScanMetrics();
        int numberOfMetrics = metrics.getMetricsCount();
        for (int i = 0; i < numberOfMetrics; ++i) {
            HBaseProtos.NameInt64Pair metricPair = metrics.getMetrics(i);
            if (metricPair == null) continue;
            String name = metricPair.getName();
            Long value = metricPair.getValue();
            if (name == null || value == null) continue;
            metricMap.put(name, value);
        }
        return metricMap;
    }
}

