/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
public interface WALActionsListener {
    public void preLogRoll(Path var1, Path var2) throws IOException;

    public void postLogRoll(Path var1, Path var2) throws IOException;

    public void preLogArchive(Path var1, Path var2) throws IOException;

    public void postLogArchive(Path var1, Path var2) throws IOException;

    public void logRollRequested(boolean var1);

    public void logCloseRequested();

    public void visitLogEntryBeforeWrite(HRegionInfo var1, WALKey var2, WALEdit var3);

    public void visitLogEntryBeforeWrite(HTableDescriptor var1, WALKey var2, WALEdit var3);

    public void postAppend(long var1, long var3);

    public void postSync(long var1, int var3);

    public static class Base
    implements WALActionsListener {
        @Override
        public void preLogRoll(Path oldPath, Path newPath) throws IOException {
        }

        @Override
        public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        }

        @Override
        public void preLogArchive(Path oldPath, Path newPath) throws IOException {
        }

        @Override
        public void postLogArchive(Path oldPath, Path newPath) throws IOException {
        }

        @Override
        public void logRollRequested(boolean tooFewReplicas) {
        }

        @Override
        public void logCloseRequested() {
        }

        @Override
        public void visitLogEntryBeforeWrite(HRegionInfo info, WALKey logKey, WALEdit logEdit) {
        }

        @Override
        public void visitLogEntryBeforeWrite(HTableDescriptor htd, WALKey logKey, WALEdit logEdit) {
        }

        @Override
        public void postAppend(long entryLen, long elapsedTimeMillis) {
        }

        @Override
        public void postSync(long timeInNanos, int handlerSyncs) {
        }
    }
}

