/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.com.google.protobuf.ServiceException;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hudi.org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class VisibilityClient {
    public static boolean isCellVisibilityEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.CELL_VISIBILITY);
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabel(Configuration conf, String label) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.addLabels(connection, new String[]{label});
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabel(Connection connection, String label) throws Throwable {
        return VisibilityClient.addLabels(connection, new String[]{label});
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabels(Configuration conf, String[] labels) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.addLabels(connection, labels);
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabels(Connection connection, final String[] labels) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.VisibilityLabelsRequest.Builder builder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
                    for (String label : labels) {
                        if (label.length() <= 0) continue;
                        VisibilityLabelsProtos.VisibilityLabel.Builder newBuilder = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
                        newBuilder.setLabel(ByteStringer.wrap(Bytes.toBytes(label)));
                        builder.addVisLabel(newBuilder.build());
                    }
                    service.addLabels(this.controller, builder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result.values().iterator().next();
            return visibilityLabelsResponse;
        }
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse setAuths(Configuration conf, String[] auths, String user) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setOrClearAuths(connection, auths, user, true);
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse setAuths(Connection connection, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(connection, auths, user, true);
    }

    @Deprecated
    public static VisibilityLabelsProtos.GetAuthsResponse getAuths(Configuration conf, String user) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = VisibilityClient.getAuths(connection, user);
            return getAuthsResponse;
        }
    }

    public static VisibilityLabelsProtos.GetAuthsResponse getAuths(Connection connection, final String user) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.GetAuthsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.GetAuthsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.GetAuthsRequest.Builder getAuthReqBuilder = VisibilityLabelsProtos.GetAuthsRequest.newBuilder();
                    getAuthReqBuilder.setUser(ByteStringer.wrap(Bytes.toBytes(user)));
                    service.getAuths(this.controller, getAuthReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.GetAuthsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.GetAuthsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = result.values().iterator().next();
            return getAuthsResponse;
        }
    }

    @Deprecated
    public static VisibilityLabelsProtos.ListLabelsResponse listLabels(Configuration conf, String regex) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.ListLabelsResponse listLabelsResponse = VisibilityClient.listLabels(connection, regex);
            return listLabelsResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisibilityLabelsProtos.ListLabelsResponse listLabels(Connection connection, final String regex) throws Throwable {
        Table table = null;
        try {
            table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.ListLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.ListLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.ListLabelsRequest.Builder listAuthLabelsReqBuilder = VisibilityLabelsProtos.ListLabelsRequest.newBuilder();
                    if (regex != null) {
                        Pattern pattern = Pattern.compile(regex);
                        listAuthLabelsReqBuilder.setRegex(pattern.toString());
                    }
                    service.listLabels(this.controller, listAuthLabelsReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.ListLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.ListLabelsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.ListLabelsResponse listLabelsResponse = result.values().iterator().next();
            return listLabelsResponse;
        }
        finally {
            if (table != null) {
                table.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Deprecated
    public static VisibilityLabelsProtos.VisibilityLabelsResponse clearAuths(Configuration conf, String[] auths, String user) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setOrClearAuths(connection, auths, user, false);
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse clearAuths(Connection connection, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(connection, auths, user, false);
    }

    private static VisibilityLabelsProtos.VisibilityLabelsResponse setOrClearAuths(Connection connection, final String[] auths, final String user, final boolean setOrClear) throws IOException, ServiceException, Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.SetAuthsRequest.Builder setAuthReqBuilder = VisibilityLabelsProtos.SetAuthsRequest.newBuilder();
                    setAuthReqBuilder.setUser(ByteStringer.wrap(Bytes.toBytes(user)));
                    for (String auth : auths) {
                        if (auth.length() <= 0) continue;
                        setAuthReqBuilder.addAuth(ByteStringer.wrap(Bytes.toBytes(auth)));
                    }
                    if (setOrClear) {
                        service.setAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    } else {
                        service.clearAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    }
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result.values().iterator().next();
            return visibilityLabelsResponse;
        }
    }
}

