/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.DefaultVisibilityLabelServiceImpl;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;

@InterfaceAudience.Private
public class VisibilityLabelServiceManager {
    private static final Log LOG = LogFactory.getLog(VisibilityLabelServiceManager.class);
    public static final String VISIBILITY_LABEL_SERVICE_CLASS = "hbase.regionserver.visibility.label.service.class";
    private static final VisibilityLabelServiceManager INSTANCE = new VisibilityLabelServiceManager();
    private volatile VisibilityLabelService visibilityLabelService = null;
    private String vlsClazzName = null;

    private VisibilityLabelServiceManager() {
    }

    public static VisibilityLabelServiceManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisibilityLabelService getVisibilityLabelService(Configuration conf) throws IOException {
        String vlsClassName = conf.get(VISIBILITY_LABEL_SERVICE_CLASS, DefaultVisibilityLabelServiceImpl.class.getCanonicalName()).trim();
        if (this.visibilityLabelService != null) {
            this.checkForClusterLevelSingleConf(vlsClassName);
            return this.visibilityLabelService;
        }
        VisibilityLabelServiceManager visibilityLabelServiceManager = this;
        synchronized (visibilityLabelServiceManager) {
            if (this.visibilityLabelService != null) {
                this.checkForClusterLevelSingleConf(vlsClassName);
                return this.visibilityLabelService;
            }
            this.vlsClazzName = vlsClassName;
            try {
                this.visibilityLabelService = (VisibilityLabelService)ReflectionUtils.newInstance(Class.forName(vlsClassName), (Configuration)conf);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            return this.visibilityLabelService;
        }
    }

    private void checkForClusterLevelSingleConf(String vlsClassName) {
        assert (this.vlsClazzName != null);
        if (!this.vlsClazzName.equals(vlsClassName)) {
            LOG.warn((Object)("Trying to use table specific value for config 'hbase.regionserver.visibility.label.service.class' which is not supported. Will use the cluster level VisibilityLabelService class " + this.vlsClazzName));
        }
    }

    public VisibilityLabelService getVisibilityLabelService() {
        if (this.visibilityLabelService == null) {
            throw new IllegalStateException("VisibilityLabelService not yet instantiated");
        }
        return this.visibilityLabelService;
    }
}

