/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.visibility.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.expression.Operator;

@InterfaceAudience.Private
public class NonLeafExpressionNode
implements ExpressionNode {
    private Operator op;
    private List<ExpressionNode> childExps = new ArrayList<ExpressionNode>(2);

    public NonLeafExpressionNode() {
    }

    public NonLeafExpressionNode(Operator op) {
        this.op = op;
    }

    public NonLeafExpressionNode(Operator op, List<ExpressionNode> exps) {
        this.op = op;
        if (op == Operator.NOT && exps.size() > 1) {
            throw new IllegalArgumentException((Object)((Object)Operator.NOT) + " should be on 1 child expression");
        }
        this.childExps = exps;
    }

    public NonLeafExpressionNode(Operator op, ExpressionNode ... exps) {
        this.op = op;
        ArrayList<ExpressionNode> expLst = new ArrayList<ExpressionNode>();
        Collections.addAll(expLst, exps);
        this.childExps = expLst;
    }

    public Operator getOperator() {
        return this.op;
    }

    public List<ExpressionNode> getChildExps() {
        return this.childExps;
    }

    public void addChildExp(ExpressionNode exp) {
        if (this.op == Operator.NOT && this.childExps.size() == 1) {
            throw new IllegalStateException((Object)((Object)Operator.NOT) + " should be on 1 child expression");
        }
        this.childExps.add(exp);
    }

    public void addChildExps(List<ExpressionNode> exps) {
        this.childExps.addAll(exps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        if (this.op == Operator.NOT) {
            sb.append((Object)this.op);
        }
        for (int i = 0; i < this.childExps.size(); ++i) {
            sb.append(this.childExps.get(i));
            if (i >= this.childExps.size() - 1) continue;
            sb.append(" " + (Object)((Object)this.op) + " ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isSingleNode() {
        return this.op == Operator.NOT;
    }

    @Override
    public NonLeafExpressionNode deepClone() {
        NonLeafExpressionNode clone = new NonLeafExpressionNode(this.op);
        for (ExpressionNode exp : this.childExps) {
            clone.addChildExp(exp.deepClone());
        }
        return clone;
    }
}

