/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedInt8
extends OrderedBytesBase<Byte> {
    public static final OrderedInt8 ASCENDING = new OrderedInt8(Order.ASCENDING);
    public static final OrderedInt8 DESCENDING = new OrderedInt8(Order.DESCENDING);

    protected OrderedInt8(Order order) {
        super(order);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int encodedLength(Byte val) {
        return 2;
    }

    @Override
    public Class<Byte> encodedClass() {
        return Byte.class;
    }

    @Override
    public Byte decode(PositionedByteRange src) {
        return OrderedBytes.decodeInt8(src);
    }

    @Override
    public int encode(PositionedByteRange dst, Byte val) {
        if (null == val) {
            throw new IllegalArgumentException("Null values not supported.");
        }
        return OrderedBytes.encodeInt8(dst, val, this.order);
    }

    public byte decodeByte(PositionedByteRange src) {
        return OrderedBytes.decodeInt8(src);
    }

    public int encodeByte(PositionedByteRange dst, byte val) {
        return OrderedBytes.encodeInt8(dst, val, this.order);
    }
}

