/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ConcatenatedLists<T>
implements Collection<T> {
    protected final ArrayList<List<T>> components = new ArrayList();
    protected int size = 0;

    public void addAllSublists(List<? extends List<T>> items) {
        for (List<T> list : items) {
            this.addSublist(list);
        }
    }

    public void addSublist(List<T> items) {
        if (!items.isEmpty()) {
            this.components.add(items);
            this.size += items.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (List<T> component : this.components) {
            if (!component.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        return this.toArray((U[])((Object[])Array.newInstance(Object.class, this.size)));
    }

    @Override
    public <U> U[] toArray(U[] a) {
        U[] result = a.length == this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        int i = 0;
        for (List<T> component : this.components) {
            for (T t : component) {
                result[i] = t;
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public java.util.Iterator<T> iterator() {
        return new Iterator();
    }

    @SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="nextWasCalled is using by StripeStoreFileManager")
    public class Iterator
    implements java.util.Iterator<T> {
        protected int currentComponent = 0;
        protected int indexWithinComponent = -1;
        protected boolean nextWasCalled = false;

        @Override
        public boolean hasNext() {
            return this.currentComponent + 1 < ConcatenatedLists.this.components.size() || this.currentComponent + 1 == ConcatenatedLists.this.components.size() && this.indexWithinComponent + 1 < ConcatenatedLists.this.components.get(this.currentComponent).size();
        }

        @Override
        public T next() {
            if (!ConcatenatedLists.this.components.isEmpty()) {
                this.nextWasCalled = true;
                List src = ConcatenatedLists.this.components.get(this.currentComponent);
                if (++this.indexWithinComponent < src.size()) {
                    return src.get(this.indexWithinComponent);
                }
                if (++this.currentComponent < ConcatenatedLists.this.components.size()) {
                    this.indexWithinComponent = 0;
                    src = ConcatenatedLists.this.components.get(this.currentComponent);
                    assert (src.size() > 0);
                    return src.get(this.indexWithinComponent);
                }
            }
            this.nextWasCalled = false;
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

