/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.zookeeper.lock;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.InterProcessLock;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.lock.ZKInterProcessLockBase;

@InterfaceAudience.Private
public class ZKInterProcessReadLock
extends ZKInterProcessLockBase {
    private static final Log LOG = LogFactory.getLog(ZKInterProcessReadLock.class);

    public ZKInterProcessReadLock(ZooKeeperWatcher zooKeeperWatcher, String znode, byte[] metadata, InterProcessLock.MetadataHandler handler) {
        super(zooKeeperWatcher, znode, metadata, handler, "read-");
    }

    @Override
    protected String getLockPath(String createdZNode, List<String> children) throws IOException {
        TreeSet<String> writeChildren = new TreeSet<String>(ZKInterProcessLockBase.ZNodeComparator.COMPARATOR);
        for (String child : children) {
            if (!ZKInterProcessReadLock.isChildWriteLock(child)) continue;
            writeChildren.add(child);
        }
        if (writeChildren.isEmpty()) {
            return null;
        }
        SortedSet<String> lowerChildren = writeChildren.headSet(createdZNode);
        if (lowerChildren.isEmpty()) {
            return null;
        }
        String pathToWatch = lowerChildren.last();
        String nodeHoldingLock = lowerChildren.first();
        String znode = ZKUtil.joinZNode(this.parentLockNode, nodeHoldingLock);
        this.handleLockMetadata(znode);
        return pathToWatch;
    }
}

