/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.zookeeper.lock;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.InterProcessLock;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.lock.ZKInterProcessLockBase;

@InterfaceAudience.Private
public class ZKInterProcessWriteLock
extends ZKInterProcessLockBase {
    private static final Log LOG = LogFactory.getLog(ZKInterProcessWriteLock.class);

    public ZKInterProcessWriteLock(ZooKeeperWatcher zooKeeperWatcher, String znode, byte[] metadata, InterProcessLock.MetadataHandler handler) {
        super(zooKeeperWatcher, znode, metadata, handler, "write-");
    }

    @Override
    protected String getLockPath(String createdZNode, List<String> children) throws IOException {
        TreeSet<String> sortedChildren = new TreeSet<String>(ZKInterProcessLockBase.ZNodeComparator.COMPARATOR);
        sortedChildren.addAll(children);
        String pathToWatch = sortedChildren.lower(createdZNode);
        if (pathToWatch != null) {
            String nodeHoldingLock = sortedChildren.first();
            String znode = ZKUtil.joinZNode(this.parentLockNode, nodeHoldingLock);
            this.handleLockMetadata(znode);
        }
        return pathToWatch;
    }
}

