/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.raptor.RaptorConnector;
import com.facebook.presto.raptor.RaptorHandleResolver;
import com.facebook.presto.raptor.RaptorModule;
import com.facebook.presto.raptor.RaptorProcedureModule;
import com.facebook.presto.raptor.backup.BackupModule;
import com.facebook.presto.raptor.filesystem.FileSystemModule;
import com.facebook.presto.raptor.security.RaptorSecurityModule;
import com.facebook.presto.raptor.storage.StorageModule;
import com.facebook.presto.raptor.util.RebindSafeMBeanServer;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Objects;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class RaptorConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Module metadataModule;
    private final Map<String, Module> fileSystemProviders;
    private final Map<String, Module> backupProviders;

    public RaptorConnectorFactory(String name, Module metadataModule, Map<String, Module> fileSystemProviders, Map<String, Module> backupProviders) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metadataModule = Objects.requireNonNull(metadataModule, "metadataModule is null");
        this.fileSystemProviders = Objects.requireNonNull(fileSystemProviders, "fileSystemProviders is null");
        this.backupProviders = ImmutableMap.copyOf(Objects.requireNonNull(backupProviders, "backupProviders is null"));
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new RaptorHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        NodeManager nodeManager = context.getNodeManager();
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MBeanModule(), binder -> {
                RebindSafeMBeanServer mbeanServer = new RebindSafeMBeanServer(ManagementFactory.getPlatformMBeanServer());
                binder.bind(MBeanServer.class).toInstance((Object)mbeanServer);
                binder.bind(NodeManager.class).toInstance((Object)nodeManager);
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            }, this.metadataModule, new FileSystemModule(this.fileSystemProviders), new BackupModule(this.backupProviders), new StorageModule(catalogName), new RaptorModule(catalogName), new RaptorSecurityModule(), new RaptorProcedureModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(RaptorConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

