/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.raptor.RaptorBucketFunction;
import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.raptor.RaptorInsertTableHandle;
import com.facebook.presto.raptor.RaptorOutputTableHandle;
import com.facebook.presto.raptor.RaptorPartitioningHandle;
import com.facebook.presto.raptor.RaptorSessionProperties;
import com.facebook.presto.raptor.RaptorTableHandle;
import com.facebook.presto.raptor.RaptorTableLayoutHandle;
import com.facebook.presto.raptor.RaptorTableProperties;
import com.facebook.presto.raptor.metadata.ColumnInfo;
import com.facebook.presto.raptor.metadata.DeltaInfoPair;
import com.facebook.presto.raptor.metadata.Distribution;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.ShardDeleteDelta;
import com.facebook.presto.raptor.metadata.ShardDelta;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.metadata.ShardManager;
import com.facebook.presto.raptor.metadata.Table;
import com.facebook.presto.raptor.metadata.TableColumn;
import com.facebook.presto.raptor.metadata.ViewResult;
import com.facebook.presto.raptor.storage.StorageTypeConverter;
import com.facebook.presto.raptor.systemtables.ColumnRangesSystemTable;
import com.facebook.presto.raptor.util.DatabaseUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorTablePartitioning;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;

public class RaptorMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(RaptorMetadata.class);
    private static final JsonCodec<ShardInfo> SHARD_INFO_CODEC = JsonCodec.jsonCodec(ShardInfo.class);
    private static final JsonCodec<ShardDelta> SHARD_DELTA_CODEC = JsonCodec.jsonCodec(ShardDelta.class);
    private static final JsonCodec<ShardDeleteDelta> SHARD_DELETE_DELTA_CODEC = JsonCodec.jsonCodec(ShardDeleteDelta.class);
    private final IDBI dbi;
    private final MetadataDao dao;
    private final ShardManager shardManager;
    private final TypeManager typeManager;
    private final String connectorId;
    private final LongConsumer beginDeleteForTableId;
    private final AtomicReference<Long> currentTransactionId = new AtomicReference();

    public RaptorMetadata(String connectorId, IDBI dbi, ShardManager shardManager, TypeManager typeManager) {
        this(connectorId, dbi, shardManager, typeManager, tableId -> {});
    }

    public RaptorMetadata(String connectorId, IDBI dbi, ShardManager shardManager, TypeManager typeManager, LongConsumer beginDeleteForTableId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.dbi = Objects.requireNonNull(dbi, "dbi is null");
        this.dao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.beginDeleteForTableId = Objects.requireNonNull(beginDeleteForTableId, "beginDeleteForTableId is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.dao.listSchemaNames();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.getTableHandle(tableName);
    }

    private RaptorTableHandle getTableHandle(SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        Table table = this.dao.getTableInformation(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        List<TableColumn> tableColumns = this.dao.listTableColumns(table.getTableId());
        Preconditions.checkArgument((!tableColumns.isEmpty() ? 1 : 0) != 0, (String)"Table %s does not have any columns", (Object)tableName);
        return new RaptorTableHandle(this.connectorId, tableName.getSchemaName(), tableName.getTableName(), table.getTableId(), table.getDistributionId(), table.getDistributionName(), table.getBucketCount(), table.isOrganized(), OptionalLong.empty(), Optional.empty(), false, table.isTableSupportsDeltaDelete());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return ColumnRangesSystemTable.getSourceTable(tableName).map(this::getTableHandle).map(handle -> new ColumnRangesSystemTable((RaptorTableHandle)handle, this.dbi));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        RaptorTableHandle handle = (RaptorTableHandle)tableHandle;
        SchemaTableName tableName = new SchemaTableName(handle.getSchemaName(), handle.getTableName());
        List<TableColumn> tableColumns = this.dao.listTableColumns(handle.getTableId());
        if (tableColumns.isEmpty()) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        TreeMap bucketing = new TreeMap();
        TreeMap ordering = new TreeMap();
        for (TableColumn column : tableColumns) {
            if (column.isTemporal()) {
                properties.put((Object)"temporal_column", (Object)column.getColumnName());
            }
            column.getBucketOrdinal().ifPresent(bucketOrdinal -> bucketing.put(bucketOrdinal, column.getColumnName()));
            column.getSortOrdinal().ifPresent(sortOrdinal -> ordering.put(sortOrdinal, column.getColumnName()));
        }
        if (!bucketing.isEmpty()) {
            properties.put((Object)"bucketed_on", (Object)ImmutableList.copyOf(bucketing.values()));
        }
        if (!ordering.isEmpty()) {
            properties.put((Object)"ordering", (Object)ImmutableList.copyOf(ordering.values()));
        }
        handle.getBucketCount().ifPresent(bucketCount -> properties.put((Object)"bucket_count", (Object)bucketCount));
        handle.getDistributionName().ifPresent(distributionName -> properties.put((Object)"distribution_name", distributionName));
        if (handle.isOrganized()) {
            properties.put((Object)"organized", (Object)true);
        }
        if (handle.isTableSupportsDeltaDelete()) {
            properties.put((Object)"table_supports_delta_delete", (Object)true);
        }
        List columns = tableColumns.stream().map(TableColumn::toColumnMetadata).collect(Collectors.toCollection(ArrayList::new));
        columns.add(RaptorMetadata.hiddenColumn("$shard_uuid", RaptorColumnHandle.SHARD_UUID_COLUMN_TYPE));
        if (handle.isBucketed()) {
            columns.add(RaptorMetadata.hiddenColumn("$bucket_number", (Type)IntegerType.INTEGER));
        }
        properties.putAll(this.getExtraProperties(handle.getTableId()));
        return new ConnectorTableMetadata(tableName, columns, (Map)properties.build());
    }

    protected Map<String, Object> getExtraProperties(long tableid) {
        return ImmutableMap.of();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, @Nullable String schemaNameOrNull) {
        return this.dao.listTables(schemaNameOrNull);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        RaptorTableHandle raptorTableHandle = (RaptorTableHandle)tableHandle;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TableColumn tableColumn : this.dao.listTableColumns(raptorTableHandle.getTableId())) {
            builder.put((Object)tableColumn.getColumnName(), (Object)this.getRaptorColumnHandle(tableColumn));
        }
        RaptorColumnHandle uuidColumn = RaptorColumnHandle.shardUuidColumnHandle(this.connectorId);
        builder.put((Object)uuidColumn.getColumnName(), (Object)uuidColumn);
        if (raptorTableHandle.isBucketed()) {
            RaptorColumnHandle bucketNumberColumn = RaptorColumnHandle.bucketNumberColumnHandle(this.connectorId);
            builder.put((Object)bucketNumberColumn.getColumnName(), (Object)bucketNumberColumn);
        }
        return builder.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        RaptorColumnHandle column = (RaptorColumnHandle)columnHandle;
        if (RaptorColumnHandle.isHiddenColumn(column.getColumnId())) {
            return RaptorMetadata.hiddenColumn(column.getColumnName(), column.getColumnType());
        }
        return new ColumnMetadata(column.getColumnName(), column.getColumnType());
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableListMultimap.Builder columns = ImmutableListMultimap.builder();
        for (TableColumn tableColumn : this.dao.listTableColumns(prefix.getSchemaName(), prefix.getTableName())) {
            ColumnMetadata columnMetadata = new ColumnMetadata(tableColumn.getColumnName(), tableColumn.getDataType());
            columns.put((Object)tableColumn.getTable(), (Object)columnMetadata);
        }
        return Multimaps.asMap((ListMultimap)columns.build());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        RaptorTableHandle handle = (RaptorTableHandle)table;
        ConnectorTableLayout layout = this.getTableLayout(session, handle, (TupleDomain<ColumnHandle>)constraint.getSummary());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        RaptorTableLayoutHandle raptorHandle = (RaptorTableLayoutHandle)handle;
        return this.getTableLayout(session, raptorHandle.getTable(), raptorHandle.getConstraint());
    }

    private ConnectorTableLayout getTableLayout(ConnectorSession session, RaptorTableHandle handle, TupleDomain<ColumnHandle> constraint) {
        if (!handle.getDistributionId().isPresent()) {
            return new ConnectorTableLayout((ConnectorTableLayoutHandle)new RaptorTableLayoutHandle(handle, constraint, Optional.empty()));
        }
        List<RaptorColumnHandle> bucketColumnHandles = this.getBucketColumnHandles(handle.getTableId());
        RaptorPartitioningHandle partitioning = this.getPartitioningHandle(handle.getDistributionId().getAsLong());
        boolean oneSplitPerBucket = handle.getBucketCount().getAsInt() >= RaptorSessionProperties.getOneSplitPerBucketThreshold(session);
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)new RaptorTableLayoutHandle(handle, constraint, Optional.of(partitioning)), Optional.empty(), TupleDomain.all(), Optional.of(new ConnectorTablePartitioning((ConnectorPartitioningHandle)partitioning, (List)ImmutableList.copyOf(bucketColumnHandles))), oneSplitPerBucket ? Optional.of(ImmutableSet.copyOf(bucketColumnHandles)) : Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata metadata) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        long columnId = 1L;
        StorageTypeConverter storageTypeConverter = new StorageTypeConverter(this.typeManager);
        for (ColumnMetadata column : metadata.getColumns()) {
            Preconditions.checkState((storageTypeConverter.toStorageType(column.getType()) != null ? 1 : 0) != 0, (Object)"storage type cannot be null");
            map.put((Object)column.getName(), (Object)new RaptorColumnHandle(this.connectorId, column.getName(), columnId, column.getType()));
            ++columnId;
        }
        Optional<DistributionInfo> distribution = this.getOrCreateDistribution((Map<String, RaptorColumnHandle>)map.build(), metadata.getProperties());
        if (!distribution.isPresent()) {
            return Optional.empty();
        }
        List partitionColumns = distribution.get().getBucketColumns().stream().map(RaptorColumnHandle::getColumnName).collect(Collectors.toList());
        RaptorPartitioningHandle partitioning = this.getPartitioningHandle(distribution.get().getDistributionId());
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioning, partitionColumns));
    }

    private RaptorPartitioningHandle getPartitioningHandle(long distributionId) {
        return new RaptorPartitioningHandle(distributionId, this.shardManager.getBucketAssignments(distributionId));
    }

    private Optional<DistributionInfo> getOrCreateDistribution(Map<String, RaptorColumnHandle> columnHandleMap, Map<String, Object> properties) {
        long distributionId;
        OptionalInt bucketCount = RaptorTableProperties.getBucketCount(properties);
        List<RaptorColumnHandle> bucketColumnHandles = RaptorMetadata.getBucketColumnHandles(RaptorTableProperties.getBucketColumns(properties), columnHandleMap);
        if (bucketCount.isPresent() && bucketColumnHandles.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Must specify '%s' along with '%s'", "bucketed_on", "bucket_count"));
        }
        if (!bucketCount.isPresent() && !bucketColumnHandles.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Must specify '%s' along with '%s'", "bucket_count", "bucketed_on"));
        }
        ImmutableList.Builder bucketColumnTypes = ImmutableList.builder();
        for (RaptorColumnHandle column : bucketColumnHandles) {
            RaptorBucketFunction.validateBucketType(column.getColumnType());
            bucketColumnTypes.add((Object)column.getColumnType());
        }
        String distributionName = RaptorTableProperties.getDistributionName(properties);
        if (distributionName != null) {
            if (bucketColumnHandles.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Must specify '%s' along with '%s'", "bucketed_on", "distribution_name"));
            }
            Distribution distribution = this.dao.getDistribution(distributionName);
            if (distribution == null) {
                if (!bucketCount.isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Distribution does not exist and bucket count is not specified");
                }
                distribution = this.getOrCreateDistribution(distributionName, (List<Type>)bucketColumnTypes.build(), bucketCount.getAsInt());
            }
            distributionId = distribution.getId();
            if (bucketCount.isPresent() && distribution.getBucketCount() != bucketCount.getAsInt()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Bucket count must match distribution");
            }
            if (!distribution.getColumnTypes().equals(bucketColumnTypes.build())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Bucket column types must match distribution");
            }
        } else if (bucketCount.isPresent()) {
            String types = Distribution.serializeColumnTypes((List<Type>)bucketColumnTypes.build());
            distributionId = this.dao.insertDistribution(null, types, bucketCount.getAsInt());
        } else {
            return Optional.empty();
        }
        this.shardManager.createBuckets(distributionId, bucketCount.getAsInt());
        return Optional.of(new DistributionInfo(distributionId, bucketCount.getAsInt(), bucketColumnHandles));
    }

    private Distribution getOrCreateDistribution(String name, List<Type> columnTypes, int bucketCount) {
        String types = Distribution.serializeColumnTypes(columnTypes);
        DatabaseUtil.runIgnoringConstraintViolation(() -> this.dao.insertDistribution(name, types, bucketCount));
        Distribution distribution = this.dao.getDistribution(name);
        if (distribution == null) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Distribution does not exist after insert");
        }
        return distribution;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional<ConnectorNewTableLayout> layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        RaptorTableHandle raptorHandle = (RaptorTableHandle)tableHandle;
        this.shardManager.dropTable(raptorHandle.getTableId());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        RaptorTableHandle table = (RaptorTableHandle)tableHandle;
        DatabaseUtil.runTransaction(this.dbi, (handle, status) -> {
            MetadataDao dao = (MetadataDao)handle.attach(MetadataDao.class);
            dao.renameTable(table.getTableId(), newTableName.getSchemaName(), newTableName.getTableName());
            return null;
        });
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        RaptorTableHandle table = (RaptorTableHandle)tableHandle;
        List<TableColumn> existingColumns = this.dao.listTableColumns(table.getSchemaName(), table.getTableName());
        TableColumn lastColumn = existingColumns.get(existingColumns.size() - 1);
        long columnId = lastColumn.getColumnId() + 1L;
        int ordinalPosition = lastColumn.getOrdinalPosition() + 1;
        StorageTypeConverter storageTypeConverter = new StorageTypeConverter(this.typeManager);
        Preconditions.checkState((storageTypeConverter.toStorageType(column.getType()) != null ? 1 : 0) != 0, (Object)"storage type cannot be null");
        String type = column.getType().getTypeSignature().toString();
        DatabaseUtil.daoTransaction(this.dbi, MetadataDao.class, dao -> {
            dao.insertColumn(table.getTableId(), columnId, column.getName(), ordinalPosition, type, null, null);
            dao.updateTableVersion(table.getTableId(), session.getStartTime());
        });
        this.shardManager.addColumn(table.getTableId(), new ColumnInfo(columnId, column.getType()));
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        RaptorTableHandle table = (RaptorTableHandle)tableHandle;
        RaptorColumnHandle sourceColumn = (RaptorColumnHandle)source;
        DatabaseUtil.daoTransaction(this.dbi, MetadataDao.class, dao -> {
            dao.renameColumn(table.getTableId(), sourceColumn.getColumnId(), target);
            dao.updateTableVersion(table.getTableId(), session.getStartTime());
        });
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        RaptorTableHandle table = (RaptorTableHandle)tableHandle;
        RaptorColumnHandle raptorColumn = (RaptorColumnHandle)column;
        List<TableColumn> existingColumns = this.dao.listTableColumns(table.getSchemaName(), table.getTableName());
        if (existingColumns.size() <= 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the only column in a table");
        }
        long maxColumnId = existingColumns.stream().mapToLong(TableColumn::getColumnId).max().getAsLong();
        if (raptorColumn.getColumnId() == maxColumnId) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the column which has the largest column ID in the table");
        }
        if (this.getBucketColumnHandles(table.getTableId()).contains(column)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop bucket columns");
        }
        Optional.ofNullable(this.dao.getTemporalColumnId(table.getTableId())).ifPresent(tempColumnId -> {
            if (raptorColumn.getColumnId() == tempColumnId.longValue()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the temporal column");
            }
        });
        if (this.getSortColumnHandles(table.getTableId()).contains(raptorColumn)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop sort columns");
        }
        DatabaseUtil.daoTransaction(this.dbi, MetadataDao.class, dao -> {
            dao.dropColumn(table.getTableId(), raptorColumn.getColumnId());
            dao.updateTableVersion(table.getTableId(), session.getStartTime());
        });
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        RaptorColumnHandle column;
        if (this.viewExists(session, tableMetadata.getTable())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + tableMetadata.getTable());
        }
        this.runExtraEligibilityCheck(session, tableMetadata);
        Optional<RaptorPartitioningHandle> partitioning = layout.map(ConnectorNewTableLayout::getPartitioning).map(RaptorPartitioningHandle.class::cast);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        long columnId = 1L;
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            columnHandles.add((Object)new RaptorColumnHandle(this.connectorId, column2.getName(), columnId, column2.getType()));
            columnTypes.add((Object)column2.getType());
            ++columnId;
        }
        ImmutableMap columnHandleMap = Maps.uniqueIndex((Iterable)columnHandles.build(), RaptorColumnHandle::getColumnName);
        List<RaptorColumnHandle> sortColumnHandles = RaptorMetadata.getSortColumnHandles(RaptorTableProperties.getSortColumns(tableMetadata.getProperties()), (Map<String, RaptorColumnHandle>)columnHandleMap);
        Optional<RaptorColumnHandle> temporalColumnHandle = RaptorMetadata.getTemporalColumnHandle(RaptorTableProperties.getTemporalColumn(tableMetadata.getProperties()), (Map<String, RaptorColumnHandle>)columnHandleMap);
        if (temporalColumnHandle.isPresent() && !(column = temporalColumnHandle.get()).getColumnType().equals(TimestampType.TIMESTAMP) && !column.getColumnType().equals(DateType.DATE)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Temporal column must be of type timestamp or date: " + column.getColumnName());
        }
        boolean organized = RaptorTableProperties.isOrganized(tableMetadata.getProperties());
        if (organized) {
            if (temporalColumnHandle.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table with temporal columns cannot be organized");
            }
            if (sortColumnHandles.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table organization requires an ordering");
            }
        }
        long transactionId = this.shardManager.beginTransaction();
        this.setTransactionId(transactionId);
        Optional<DistributionInfo> distribution = partitioning.map(arg_0 -> this.lambda$beginCreateTable$12((Map)columnHandleMap, tableMetadata, arg_0));
        return new RaptorOutputTableHandle(this.connectorId, transactionId, tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), (List<RaptorColumnHandle>)columnHandles.build(), (List<Type>)columnTypes.build(), sortColumnHandles, Collections.nCopies(sortColumnHandles.size(), SortOrder.ASC_NULLS_FIRST), temporalColumnHandle, distribution.map(info -> OptionalLong.of(info.getDistributionId())).orElse(OptionalLong.empty()), distribution.map(info -> OptionalInt.of(info.getBucketCount())).orElse(OptionalInt.empty()), distribution.map(DistributionInfo::getBucketColumns).orElse((List)ImmutableList.of()), organized, RaptorTableProperties.isTableSupportsDeltaDelete(tableMetadata.getProperties()), tableMetadata.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString())));
    }

    private DistributionInfo getDistributionInfo(long distributionId, Map<String, RaptorColumnHandle> columnHandleMap, Map<String, Object> properties) {
        Distribution distribution = this.dao.getDistribution(distributionId);
        if (distribution == null) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Distribution ID does not exist: " + distributionId);
        }
        List<RaptorColumnHandle> bucketColumnHandles = RaptorMetadata.getBucketColumnHandles(RaptorTableProperties.getBucketColumns(properties), columnHandleMap);
        return new DistributionInfo(distributionId, distribution.getBucketCount(), bucketColumnHandles);
    }

    private static Optional<RaptorColumnHandle> getTemporalColumnHandle(String temporalColumn, Map<String, RaptorColumnHandle> columnHandleMap) {
        if (temporalColumn == null) {
            return Optional.empty();
        }
        RaptorColumnHandle handle = columnHandleMap.get(temporalColumn);
        if (handle == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Temporal column does not exist: " + temporalColumn);
        }
        return Optional.of(handle);
    }

    private static List<RaptorColumnHandle> getSortColumnHandles(List<String> sortColumns, Map<String, RaptorColumnHandle> columnHandleMap) {
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        for (String column : sortColumns) {
            if (!columnHandleMap.containsKey(column)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Ordering column does not exist: " + column);
            }
            columnHandles.add((Object)columnHandleMap.get(column));
        }
        return columnHandles.build();
    }

    private static List<RaptorColumnHandle> getBucketColumnHandles(List<String> bucketColumns, Map<String, RaptorColumnHandle> columnHandleMap) {
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        for (String column : bucketColumns) {
            if (!columnHandleMap.containsKey(column)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Bucketing column does not exist: " + column);
            }
            columnHandles.add((Object)columnHandleMap.get(column));
        }
        return columnHandles.build();
    }

    protected void runExtraEligibilityCheck(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        RaptorOutputTableHandle table = (RaptorOutputTableHandle)outputTableHandle;
        long transactionId = table.getTransactionId();
        long updateTime = session.getStartTime();
        long newTableId = (Long)DatabaseUtil.runTransaction(this.dbi, (dbiHandle, status) -> {
            MetadataDao dao = (MetadataDao)dbiHandle.attach(MetadataDao.class);
            Long distributionId = table.getDistributionId().isPresent() ? Long.valueOf(table.getDistributionId().getAsLong()) : null;
            long tableId = dao.insertTable(table.getSchemaName(), table.getTableName(), true, table.isOrganized(), distributionId, updateTime, table.isTableSupportsDeltaDelete());
            this.runExtraCreateTableStatement(tableId, dbiHandle, table.getProperties());
            List<RaptorColumnHandle> sortColumnHandles = table.getSortColumnHandles();
            List<RaptorColumnHandle> bucketColumnHandles = table.getBucketColumnHandles();
            for (int i = 0; i < table.getColumnTypes().size(); ++i) {
                RaptorColumnHandle column = table.getColumnHandles().get(i);
                int columnId = i + 1;
                String type = table.getColumnTypes().get(i).getTypeSignature().toString();
                Integer sortPosition = sortColumnHandles.contains(column) ? Integer.valueOf(sortColumnHandles.indexOf(column)) : null;
                Integer bucketPosition = bucketColumnHandles.contains(column) ? Integer.valueOf(bucketColumnHandles.indexOf(column)) : null;
                dao.insertColumn(tableId, columnId, column.getColumnName(), i, type, sortPosition, bucketPosition);
                if (!table.getTemporalColumnHandle().isPresent() || !table.getTemporalColumnHandle().get().equals(column)) continue;
                dao.updateTemporalColumnId(tableId, columnId);
            }
            return tableId;
        });
        List<ColumnInfo> columns = table.getColumnHandles().stream().map(ColumnInfo::fromHandle).collect(Collectors.toList());
        OptionalLong temporalColumnId = table.getTemporalColumnHandle().map(RaptorColumnHandle::getColumnId).map(OptionalLong::of).orElse(OptionalLong.empty());
        this.shardManager.createTable(newTableId, columns, table.getBucketCount().isPresent(), temporalColumnId, table.isTableSupportsDeltaDelete());
        this.shardManager.commitShards(transactionId, newTableId, columns, RaptorMetadata.parseFragments(fragments), Optional.empty(), updateTime);
        this.clearRollback();
        return Optional.empty();
    }

    protected void runExtraCreateTableStatement(long tableId, Handle dbiHandle, Map<String, String> extraProperties) {
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        RaptorTableHandle handle = (RaptorTableHandle)tableHandle;
        long tableId = handle.getTableId();
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        for (TableColumn column : this.dao.listTableColumns(tableId)) {
            columnHandles.add((Object)new RaptorColumnHandle(this.connectorId, column.getColumnName(), column.getColumnId(), column.getDataType()));
            columnTypes.add((Object)column.getDataType());
        }
        long transactionId = this.shardManager.beginTransaction();
        this.setTransactionId(transactionId);
        Optional<String> externalBatchId = RaptorSessionProperties.getExternalBatchId(session);
        List<RaptorColumnHandle> sortColumnHandles = this.getSortColumnHandles(tableId);
        List<RaptorColumnHandle> bucketColumnHandles = this.getBucketColumnHandles(tableId);
        Optional<RaptorColumnHandle> temporalColumnHandle = Optional.ofNullable(this.dao.getTemporalColumnId(tableId)).map(temporalColumnId -> (RaptorColumnHandle)Iterables.getOnlyElement((Iterable)columnHandles.build().stream().filter(columnHandle -> columnHandle.getColumnId() == temporalColumnId.longValue()).collect(Collectors.toList())));
        return new RaptorInsertTableHandle(this.connectorId, transactionId, tableId, (List<RaptorColumnHandle>)columnHandles.build(), (List<Type>)columnTypes.build(), externalBatchId, sortColumnHandles, Collections.nCopies(sortColumnHandles.size(), SortOrder.ASC_NULLS_FIRST), handle.getBucketCount(), bucketColumnHandles, temporalColumnHandle);
    }

    private List<RaptorColumnHandle> getSortColumnHandles(long tableId) {
        return this.dao.listSortColumns(tableId).stream().map(this::getRaptorColumnHandle).collect(Collectors.toList());
    }

    private List<RaptorColumnHandle> getBucketColumnHandles(long tableId) {
        return this.dao.listBucketColumns(tableId).stream().map(this::getRaptorColumnHandle).collect(Collectors.toList());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        RaptorInsertTableHandle handle = (RaptorInsertTableHandle)insertHandle;
        long transactionId = handle.getTransactionId();
        long tableId = handle.getTableId();
        Optional<String> externalBatchId = handle.getExternalBatchId();
        List<ColumnInfo> columns = handle.getColumnHandles().stream().map(ColumnInfo::fromHandle).collect(Collectors.toList());
        long updateTime = session.getStartTime();
        Collection<ShardInfo> shards = RaptorMetadata.parseFragments(fragments);
        log.info("Committing insert into tableId %s (queryId: %s, shards: %s, columns: %s)", new Object[]{handle.getTableId(), session.getQueryId(), shards.size(), columns.size()});
        this.shardManager.commitShards(transactionId, tableId, columns, shards, externalBatchId, updateTime);
        this.clearRollback();
        return Optional.empty();
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return RaptorColumnHandle.shardRowIdHandle(this.connectorId);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        RaptorTableHandle handle = (RaptorTableHandle)tableHandle;
        this.beginDeleteForTableId.accept(handle.getTableId());
        long transactionId = this.shardManager.beginTransaction();
        this.setTransactionId(transactionId);
        Map<String, Type> columnTypes = this.dao.listTableColumns(handle.getTableId()).stream().collect(Collectors.toMap(k -> String.valueOf(k.getColumnId()), TableColumn::getDataType));
        return new RaptorTableHandle(this.connectorId, handle.getSchemaName(), handle.getTableName(), handle.getTableId(), handle.getDistributionId(), handle.getDistributionName(), handle.getBucketCount(), handle.isOrganized(), OptionalLong.of(transactionId), Optional.of(columnTypes), true, handle.isTableSupportsDeltaDelete());
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        RaptorTableHandle table = (RaptorTableHandle)tableHandle;
        long transactionId = table.getTransactionId().getAsLong();
        long tableId = table.getTableId();
        List<ColumnInfo> columns = this.getColumnHandles(session, tableHandle).values().stream().map(RaptorColumnHandle.class::cast).map(ColumnInfo::fromHandle).collect(Collectors.toList());
        if (table.isTableSupportsDeltaDelete()) {
            ImmutableMap.Builder shardMapBuilder = ImmutableMap.builder();
            fragments.stream().map(fragment -> (ShardDeleteDelta)SHARD_DELETE_DELTA_CODEC.fromJson(fragment.getBytes())).forEach(delta -> shardMapBuilder.put((Object)delta.getOldShardUuid(), (Object)delta.getDeltaInfoPair()));
            OptionalLong updateTime = OptionalLong.of(session.getStartTime());
            log.info("Finishing delete for tableId %s (affected shardUuid: %s)", new Object[]{tableId, shardMapBuilder.build().size()});
            this.shardManager.replaceDeltaUuids(transactionId, tableId, columns, (Map<UUID, DeltaInfoPair>)shardMapBuilder.build(), updateTime);
        } else {
            ImmutableSet.Builder oldShardUuidsBuilder = ImmutableSet.builder();
            ImmutableList.Builder newShardsBuilder = ImmutableList.builder();
            fragments.stream().map(fragment -> (ShardDelta)SHARD_DELTA_CODEC.fromJson(fragment.getBytes())).forEach(delta -> {
                oldShardUuidsBuilder.addAll(delta.getOldShardUuids());
                newShardsBuilder.addAll(delta.getNewShards());
            });
            ImmutableSet oldShardUuids = oldShardUuidsBuilder.build();
            ImmutableList newShards = newShardsBuilder.build();
            OptionalLong updateTime = OptionalLong.of(session.getStartTime());
            log.info("Finishing delete for tableId %s (removed: %s, rewritten: %s)", new Object[]{tableId, oldShardUuids.size() - newShards.size(), newShards.size()});
            this.shardManager.replaceShardUuids(transactionId, tableId, columns, (Set<UUID>)oldShardUuids, (Collection<ShardInfo>)newShards, updateTime);
        }
        this.clearRollback();
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle) {
        return false;
    }

    public void createView(ConnectorSession session, ConnectorTableMetadata viewMetadata, String viewData, boolean replace) {
        SchemaTableName viewName = viewMetadata.getTable();
        String schemaName = viewName.getSchemaName();
        String tableName = viewName.getTableName();
        if (this.getTableHandle(viewName) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists: " + viewName);
        }
        if (replace) {
            DatabaseUtil.daoTransaction(this.dbi, MetadataDao.class, dao -> {
                dao.dropView(schemaName, tableName);
                dao.insertView(schemaName, tableName, viewData);
            });
            return;
        }
        try {
            this.dao.insertView(schemaName, tableName, viewData);
        }
        catch (PrestoException e) {
            if (this.viewExists(session, viewName)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + viewName);
            }
            throw e;
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (!this.viewExists(session, viewName)) {
            throw new ViewNotFoundException(viewName);
        }
        this.dao.dropView(viewName.getSchemaName(), viewName.getTableName());
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        return this.dao.listViews(schemaNameOrNull);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ViewResult view : this.dao.getViews(prefix.getSchemaName(), prefix.getTableName())) {
            map.put((Object)view.getName(), (Object)new ConnectorViewDefinition(view.getName(), Optional.empty(), view.getData()));
        }
        return map.build();
    }

    private boolean viewExists(ConnectorSession session, SchemaTableName viewName) {
        return !this.getViews(session, viewName.toSchemaTablePrefix()).isEmpty();
    }

    private RaptorColumnHandle getRaptorColumnHandle(TableColumn tableColumn) {
        return new RaptorColumnHandle(this.connectorId, tableColumn.getColumnName(), tableColumn.getColumnId(), tableColumn.getDataType());
    }

    private static Collection<ShardInfo> parseFragments(Collection<Slice> fragments) {
        return fragments.stream().map(fragment -> (ShardInfo)SHARD_INFO_CODEC.fromJson(fragment.getBytes())).collect(Collectors.toList());
    }

    private static ColumnMetadata hiddenColumn(String name, Type type) {
        return new ColumnMetadata(name, type, null, true);
    }

    private void setTransactionId(long transactionId) {
        Preconditions.checkState((boolean)this.currentTransactionId.compareAndSet(null, transactionId), (Object)"current transaction ID already set");
    }

    private void clearRollback() {
        this.currentTransactionId.set(null);
    }

    public void rollback() {
        Long transactionId = this.currentTransactionId.getAndSet(null);
        if (transactionId != null) {
            this.shardManager.rollbackTransaction(transactionId);
        }
    }

    private /* synthetic */ DistributionInfo lambda$beginCreateTable$12(Map columnHandleMap, ConnectorTableMetadata tableMetadata, RaptorPartitioningHandle handle) {
        return this.getDistributionInfo(handle.getDistributionId(), columnHandleMap, tableMetadata.getProperties());
    }

    private static class DistributionInfo {
        private final long distributionId;
        private final int bucketCount;
        private final List<RaptorColumnHandle> bucketColumns;

        public DistributionInfo(long distributionId, int bucketCount, List<RaptorColumnHandle> bucketColumns) {
            this.distributionId = distributionId;
            this.bucketCount = bucketCount;
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
        }

        public long getDistributionId() {
            return this.distributionId;
        }

        public int getBucketCount() {
            return this.bucketCount;
        }

        public List<RaptorColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }
    }
}

