/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.raptor.RaptorErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import io.airlift.slice.XxHash64;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class FileSystemUtil {
    public static final HdfsContext DEFAULT_RAPTOR_CONTEXT = new HdfsContext(new ConnectorIdentity("presto-raptor", Optional.empty(), Optional.empty()));
    private static final Configuration INITIAL_CONFIGURATION;

    private FileSystemUtil() {
    }

    public static Configuration getInitialConfiguration() {
        return FileSystemUtil.copy(INITIAL_CONFIGURATION);
    }

    public static Configuration copy(Configuration configuration) {
        Configuration copy = new Configuration(false);
        FileSystemUtil.copy(configuration, copy);
        return copy;
    }

    public static void copy(Configuration from, Configuration to) {
        for (Map.Entry entry : from) {
            to.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long xxhash64(FileSystem fileSystem, Path file) {
        try (FSDataInputStream in = fileSystem.open(file);){
            long l = XxHash64.hash((InputStream)in);
            return l;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to read file: " + file, (Throwable)e);
        }
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        INITIAL_CONFIGURATION = new Configuration(false);
        Configuration defaultConfiguration = new Configuration();
        FileSystemUtil.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

