/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class BucketNode {
    private final int bucketNumber;
    private final String nodeIdentifier;

    public BucketNode(int bucketNumber, String nodeIdentifier) {
        Preconditions.checkArgument((bucketNumber >= 0 ? 1 : 0) != 0, (Object)"bucket number must be positive");
        this.bucketNumber = bucketNumber;
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null");
    }

    public int getBucketNumber() {
        return this.bucketNumber;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketNode that = (BucketNode)o;
        return this.bucketNumber == that.bucketNumber && Objects.equals(this.nodeIdentifier, that.nodeIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.bucketNumber, this.nodeIdentifier);
    }

    public String toString() {
        return this.bucketNumber + ":" + this.nodeIdentifier;
    }

    public static class Mapper
    implements ResultSetMapper<BucketNode> {
        public BucketNode map(int index, ResultSet rs, StatementContext context) throws SQLException {
            return new BucketNode(rs.getInt("bucket_number"), rs.getString("node_identifier"));
        }
    }
}

