/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.security;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.presto.plugin.base.security.AllowAllAccessControlModule;
import com.facebook.presto.plugin.base.security.FileBasedAccessControlModule;
import com.facebook.presto.plugin.base.security.ReadOnlySecurityModule;
import com.facebook.presto.raptor.security.RaptorSecurityConfig;
import com.google.inject.Binder;
import com.google.inject.Module;

public class RaptorSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindSecurityModule("none", (Module)new AllowAllAccessControlModule());
        this.bindSecurityModule("read-only", (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule("file", (Module)new FileBasedAccessControlModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(RaptorSecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), (Module)module));
    }
}

