/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.raptor.backup.BackupManager;
import com.facebook.presto.raptor.metadata.ShardDelta;
import com.facebook.presto.raptor.metadata.ShardInfo;
import com.facebook.presto.raptor.metadata.ShardRecorder;
import com.facebook.presto.raptor.storage.OrcFileInfo;
import com.facebook.presto.raptor.storage.OrcStorageManager;
import com.facebook.presto.raptor.storage.ShardRewriter;
import com.facebook.presto.raptor.storage.StorageService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class InplaceShardRewriter
implements ShardRewriter {
    private static final JsonCodec<ShardDelta> SHARD_DELTA_CODEC = JsonCodec.jsonCodec(ShardDelta.class);
    private final UUID shardUuid;
    private final Map<String, Type> columns;
    private final ExecutorService deletionExecutor;
    private final long transactionId;
    private final OptionalInt bucketNumber;
    private final String nodeId;
    private final OrcStorageManager orcStorageManager;
    private final FileSystem fileSystem;
    private final StorageService storageService;
    private final ShardRecorder shardRecorder;
    private final BackupManager backupManager;

    public InplaceShardRewriter(UUID shardUuid, Map<String, Type> columns, ExecutorService deletionExecutor, long transactionId, OptionalInt bucketNumber, String nodeId, OrcStorageManager orcStorageManager, FileSystem fileSystem, StorageService storageService, ShardRecorder shardRecorder, BackupManager backupManager) {
        this.shardUuid = Objects.requireNonNull(shardUuid, "shardUuid is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.deletionExecutor = Objects.requireNonNull(deletionExecutor, "deletionExecutor is null");
        this.transactionId = transactionId;
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
        this.orcStorageManager = Objects.requireNonNull(orcStorageManager, "orcStorageManager is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.storageService = Objects.requireNonNull(storageService, "storageService is null");
        this.shardRecorder = Objects.requireNonNull(shardRecorder, "shardRecorder is null");
        this.backupManager = Objects.requireNonNull(backupManager, "backupManager is null");
    }

    @Override
    public CompletableFuture<Collection<Slice>> rewrite(BitSet rowsToDelete) {
        if (rowsToDelete.isEmpty()) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        return CompletableFuture.supplyAsync(() -> this.rewriteShard(rowsToDelete), this.deletionExecutor);
    }

    @VisibleForTesting
    Collection<Slice> rewriteShard(BitSet rowsToDelete) {
        Path output;
        if (rowsToDelete.isEmpty()) {
            return ImmutableList.of();
        }
        UUID newShardUuid = UUID.randomUUID();
        Path input = this.storageService.getStorageFile(this.shardUuid);
        OrcFileInfo info = this.orcStorageManager.rewriteFile(this.fileSystem, this.columns, input, output = this.storageService.getStagingFile(newShardUuid), rowsToDelete);
        long rowCount = info.getRowCount();
        if (rowCount == 0L) {
            return InplaceShardRewriter.shardDelta(this.shardUuid, Optional.empty());
        }
        this.shardRecorder.recordCreatedShard(this.transactionId, newShardUuid);
        MoreFutures.getFutureValue(this.backupManager.submit(newShardUuid, output));
        ImmutableSet nodes = ImmutableSet.of((Object)this.nodeId);
        long uncompressedSize = info.getUncompressedSize();
        ShardInfo shard = this.orcStorageManager.createShardInfo(this.fileSystem, newShardUuid, this.bucketNumber, output, (Set<String>)nodes, rowCount, uncompressedSize);
        this.orcStorageManager.writeShard(newShardUuid);
        return InplaceShardRewriter.shardDelta(this.shardUuid, Optional.of(shard));
    }

    private static Collection<Slice> shardDelta(UUID oldShardUuid, Optional<ShardInfo> shardInfo) {
        List newShards = (List)shardInfo.map(ImmutableList::of).orElse(ImmutableList.of());
        ShardDelta delta = new ShardDelta((List<UUID>)ImmutableList.of((Object)oldShardUuid), newShards);
        return ImmutableList.of((Object)Slices.wrappedBuffer((byte[])SHARD_DELTA_CODEC.toJsonBytes((Object)delta)));
    }
}

