/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.raptor.storage.OrcPageSource;
import com.facebook.presto.raptor.storage.ShardRewriter;
import com.facebook.presto.spi.UpdatablePageSource;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.BitSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class OrcUpdatablePageSource
implements UpdatablePageSource {
    private final Optional<ShardRewriter> shardRewriter;
    private final OrcPageSource parentPageSource;
    private final BitSet rowsToDelete;

    public OrcUpdatablePageSource(Optional<ShardRewriter> shardRewriter, OrcBatchRecordReader recordReader, OrcPageSource parentPageSource) {
        this.shardRewriter = Objects.requireNonNull(shardRewriter, "shardRewriter is null");
        Objects.requireNonNull(recordReader, "recordReader is null");
        this.parentPageSource = Objects.requireNonNull(parentPageSource, "parentPageSource is null");
        this.rowsToDelete = new BitSet(Math.toIntExact(recordReader.getFileRowCount()));
    }

    public long getCompletedBytes() {
        return this.parentPageSource.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.parentPageSource.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.parentPageSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.parentPageSource.isFinished();
    }

    public Page getNextPage() {
        return this.parentPageSource.getNextPage();
    }

    public void close() {
        this.parentPageSource.close();
    }

    public String toString() {
        return this.parentPageSource.toString();
    }

    public void deleteRows(Block rowIds) {
        for (int i = 0; i < rowIds.getPositionCount(); ++i) {
            long rowId = BigintType.BIGINT.getLong(rowIds, i);
            this.rowsToDelete.set(Math.toIntExact(rowId));
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        Preconditions.checkState((boolean)this.shardRewriter.isPresent(), (Object)"shardRewriter is missing");
        return this.shardRewriter.get().rewrite(this.rowsToDelete);
    }

    public long getSystemMemoryUsage() {
        return this.parentPageSource.getSystemMemoryUsage();
    }
}

