/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.orc.metadata.CompressionKind;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.net.URI;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTimeZone;

@DefunctConfig(value={"storage.backup-directory"})
public class StorageManagerConfig {
    private URI dataDirectory;
    private String fileSystemProvider = "file";
    private DataSize minAvailableSpace = new DataSize(0.0, DataSize.Unit.BYTE);
    private Duration shardRecoveryTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration missingShardDiscoveryInterval = new Duration(5.0, TimeUnit.MINUTES);
    private boolean compactionEnabled = true;
    private Duration compactionInterval = new Duration(1.0, TimeUnit.HOURS);
    private Duration shardEjectorInterval = new Duration(4.0, TimeUnit.HOURS);
    private DataSize orcMaxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxReadSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcStreamBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcTinyStripeThreshold = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private boolean orcLazyReadSmallRanges = true;
    private OrcOptimizedWriterStage orcOptimizedWriterStage = OrcOptimizedWriterStage.ENABLED;
    private CompressionKind orcCompressionKind = CompressionKind.ZSTD;
    private int deletionThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private int recoveryThreads = 10;
    private int organizationThreads = 5;
    private boolean organizationEnabled = true;
    private Duration organizationDiscoveryInterval = new Duration(6.0, TimeUnit.HOURS);
    private Duration organizationInterval = new Duration(7.0, TimeUnit.DAYS);
    private long maxShardRows = 1000000L;
    private DataSize maxShardSize = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    private DataSize maxBufferSize = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    private int oneSplitPerBucketThreshold;
    private String shardDayBoundaryTimeZone = TimeZoneKey.UTC_KEY.getId();
    private int maxAllowedFilesPerWriter = Integer.MAX_VALUE;
    private boolean zstdJniDecompressionEnabled;

    @NotNull
    public URI getDataDirectory() {
        return this.dataDirectory;
    }

    @Config(value="storage.data-directory")
    @ConfigDescription(value="Base URI to use for storing shard data")
    public StorageManagerConfig setDataDirectory(URI dataURI) {
        this.dataDirectory = dataURI;
        return this;
    }

    @NotNull
    public String getFileSystemProvider() {
        return this.fileSystemProvider;
    }

    @Config(value="storage.file-system")
    @ConfigDescription(value="File system used for storage (e.g. file, hdfs)")
    public StorageManagerConfig setFileSystemProvider(String fileSystemProvider) {
        this.fileSystemProvider = fileSystemProvider;
        return this;
    }

    @NotNull
    public DataSize getMinAvailableSpace() {
        return this.minAvailableSpace;
    }

    @Config(value="storage.min-available-space")
    @ConfigDescription(value="Minimum space that must be available on the data directory file system")
    public StorageManagerConfig setMinAvailableSpace(DataSize minAvailableSpace) {
        this.minAvailableSpace = minAvailableSpace;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxMergeDistance() {
        return this.orcMaxMergeDistance;
    }

    @Config(value="storage.orc.max-merge-distance")
    public StorageManagerConfig setOrcMaxMergeDistance(DataSize orcMaxMergeDistance) {
        this.orcMaxMergeDistance = orcMaxMergeDistance;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxReadSize() {
        return this.orcMaxReadSize;
    }

    @Config(value="storage.orc.max-read-size")
    public StorageManagerConfig setOrcMaxReadSize(DataSize orcMaxReadSize) {
        this.orcMaxReadSize = orcMaxReadSize;
        return this;
    }

    @NotNull
    public DataSize getOrcStreamBufferSize() {
        return this.orcStreamBufferSize;
    }

    @Config(value="storage.orc.stream-buffer-size")
    public StorageManagerConfig setOrcStreamBufferSize(DataSize orcStreamBufferSize) {
        this.orcStreamBufferSize = orcStreamBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcTinyStripeThreshold() {
        return this.orcTinyStripeThreshold;
    }

    @Config(value="storage.orc.tiny-stripe-threshold")
    public StorageManagerConfig setOrcTinyStripeThreshold(DataSize orcTinyStripeThreshold) {
        this.orcTinyStripeThreshold = orcTinyStripeThreshold;
        return this;
    }

    @Deprecated
    public boolean isOrcLazyReadSmallRanges() {
        return this.orcLazyReadSmallRanges;
    }

    @Deprecated
    @Config(value="storage.orc.lazy-read-small-ranges")
    public StorageManagerConfig setOrcLazyReadSmallRanges(boolean orcLazyReadSmallRanges) {
        this.orcLazyReadSmallRanges = orcLazyReadSmallRanges;
        return this;
    }

    public OrcOptimizedWriterStage getOrcOptimizedWriterStage() {
        return this.orcOptimizedWriterStage;
    }

    @Config(value="storage.orc.optimized-writer-stage")
    public StorageManagerConfig setOrcOptimizedWriterStage(OrcOptimizedWriterStage orcOptimizedWriterStage) {
        this.orcOptimizedWriterStage = orcOptimizedWriterStage;
        return this;
    }

    public CompressionKind getOrcCompressionKind() {
        return this.orcCompressionKind;
    }

    @Config(value="storage.orc.compression-kind")
    public StorageManagerConfig setOrcCompressionKind(CompressionKind orcCompressionKind) {
        this.orcCompressionKind = orcCompressionKind;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDeletionThreads() {
        return this.deletionThreads;
    }

    @Config(value="storage.max-deletion-threads")
    @ConfigDescription(value="Maximum number of threads to use for deletions")
    public StorageManagerConfig setDeletionThreads(int deletionThreads) {
        this.deletionThreads = deletionThreads;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getShardRecoveryTimeout() {
        return this.shardRecoveryTimeout;
    }

    @Config(value="storage.shard-recovery-timeout")
    @ConfigDescription(value="Maximum time to wait for a shard to recover from backup while running a query")
    public StorageManagerConfig setShardRecoveryTimeout(Duration shardRecoveryTimeout) {
        this.shardRecoveryTimeout = shardRecoveryTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getMissingShardDiscoveryInterval() {
        return this.missingShardDiscoveryInterval;
    }

    @Config(value="storage.missing-shard-discovery-interval")
    @ConfigDescription(value="How often to check the database and local file system missing shards")
    public StorageManagerConfig setMissingShardDiscoveryInterval(Duration missingShardDiscoveryInterval) {
        this.missingShardDiscoveryInterval = missingShardDiscoveryInterval;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getCompactionInterval() {
        return this.compactionInterval;
    }

    @Config(value="storage.compaction-interval")
    @ConfigDescription(value="How often to check for local shards that need compaction")
    public StorageManagerConfig setCompactionInterval(Duration compactionInterval) {
        this.compactionInterval = compactionInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public Duration getOrganizationInterval() {
        return this.organizationInterval;
    }

    @Config(value="storage.organization-interval")
    @ConfigDescription(value="How long to wait between table organization iterations")
    public StorageManagerConfig setOrganizationInterval(Duration organizationInterval) {
        this.organizationInterval = organizationInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public Duration getOrganizationDiscoveryInterval() {
        return this.organizationDiscoveryInterval;
    }

    @Config(value="storage.organization-discovery-interval")
    @ConfigDescription(value="How long to wait between discovering tables that need to be organized")
    public StorageManagerConfig setOrganizationDiscoveryInterval(Duration organizationDiscoveryInterval) {
        this.organizationDiscoveryInterval = organizationDiscoveryInterval;
        return this;
    }

    @MinDuration(value="5m")
    public Duration getShardEjectorInterval() {
        return this.shardEjectorInterval;
    }

    @Config(value="storage.ejector-interval")
    @ConfigDescription(value="How often to check for local shards that need ejection to balance capacity")
    public StorageManagerConfig setShardEjectorInterval(Duration shardEjectorInterval) {
        this.shardEjectorInterval = shardEjectorInterval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRecoveryThreads() {
        return this.recoveryThreads;
    }

    @Config(value="storage.max-recovery-threads")
    @ConfigDescription(value="Maximum number of threads to use for recovery")
    public StorageManagerConfig setRecoveryThreads(int recoveryThreads) {
        this.recoveryThreads = recoveryThreads;
        return this;
    }

    @LegacyConfig(value={"storage.max-compaction-threads"})
    @Config(value="storage.max-organization-threads")
    @ConfigDescription(value="Maximum number of threads to use for organization")
    public StorageManagerConfig setOrganizationThreads(int organizationThreads) {
        this.organizationThreads = organizationThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getOrganizationThreads() {
        return this.organizationThreads;
    }

    @Min(value=1L)
    @Max(value=1000000000L)
    public @Min(value=1L) @Max(value=1000000000L) long getMaxShardRows() {
        return this.maxShardRows;
    }

    @Config(value="storage.max-shard-rows")
    @ConfigDescription(value="Approximate maximum number of rows per shard")
    public StorageManagerConfig setMaxShardRows(long maxShardRows) {
        this.maxShardRows = maxShardRows;
        return this;
    }

    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public DataSize getMaxShardSize() {
        return this.maxShardSize;
    }

    @Config(value="storage.max-shard-size")
    @ConfigDescription(value="Approximate maximum uncompressed size of a shard")
    public StorageManagerConfig setMaxShardSize(DataSize maxShardSize) {
        this.maxShardSize = maxShardSize;
        return this;
    }

    @MinDataSize(value="1MB")
    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @Config(value="storage.max-buffer-size")
    @ConfigDescription(value="Maximum data to buffer before flushing to disk")
    public StorageManagerConfig setMaxBufferSize(DataSize maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxAllowedFilesPerWriter() {
        return this.maxAllowedFilesPerWriter;
    }

    @Config(value="storage.max-allowed-files-per-writer")
    @ConfigDescription(value="Maximum number of files that can be created per writer for a query. Default value is Integer.MAX_VALUE")
    public StorageManagerConfig setMaxAllowedFilesPerWriter(int maxAllowedFilesPerWriter) {
        this.maxAllowedFilesPerWriter = maxAllowedFilesPerWriter;
        return this;
    }

    public boolean isCompactionEnabled() {
        return this.compactionEnabled;
    }

    @Config(value="storage.compaction-enabled")
    public StorageManagerConfig setCompactionEnabled(boolean compactionEnabled) {
        this.compactionEnabled = compactionEnabled;
        return this;
    }

    public boolean isOrganizationEnabled() {
        return this.organizationEnabled;
    }

    @Config(value="storage.organization-enabled")
    public StorageManagerConfig setOrganizationEnabled(boolean organizationEnabled) {
        this.organizationEnabled = organizationEnabled;
        return this;
    }

    public int getOneSplitPerBucketThreshold() {
        return this.oneSplitPerBucketThreshold;
    }

    @Config(value="storage.one-split-per-bucket-threshold")
    @ConfigDescription(value="Experimental: Maximum bucket count at which to produce multiple splits per bucket")
    public StorageManagerConfig setOneSplitPerBucketThreshold(int oneSplitPerBucketThreshold) {
        this.oneSplitPerBucketThreshold = oneSplitPerBucketThreshold;
        return this;
    }

    public DateTimeZone getShardDayBoundaryTimeZone() {
        return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(ZoneId.of(this.shardDayBoundaryTimeZone, ZoneId.SHORT_IDS)));
    }

    @Config(value="storage.shard-day-boundary-time-zone")
    @ConfigDescription(value="Time zone to use for computing day boundary for shards")
    public StorageManagerConfig setShardDayBoundaryTimeZone(String timeZone) {
        this.shardDayBoundaryTimeZone = timeZone;
        return this;
    }

    public boolean isZstdJniDecompressionEnabled() {
        return this.zstdJniDecompressionEnabled;
    }

    @Config(value="storage.zstd-jni-decompression-enabled")
    public StorageManagerConfig setZstdJniDecompressionEnabled(boolean zstdJniDecompressionEnabled) {
        this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
        return this;
    }

    public static enum OrcOptimizedWriterStage {
        ENABLED,
        ENABLED_AND_VALIDATED;

    }
}

