/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StorageTypeConverter {
    private final TypeManager typeManager;

    public StorageTypeConverter(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public Type toStorageType(Type type) {
        Type storageType;
        if (type.equals(BooleanType.BOOLEAN) || type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type.equals(DateType.DATE) || Chars.isCharType((Type)type) || Varchars.isVarcharType((Type)type) || Decimals.isLongDecimal((Type)type) || Decimals.isShortDecimal((Type)type) || type.equals(VarbinaryType.VARBINARY)) {
            storageType = type;
        } else if (type.equals(TimeType.TIME) || type.equals(TimestampType.TIMESTAMP)) {
            storageType = BigintType.BIGINT;
        } else if (type instanceof ArrayType) {
            storageType = new ArrayType(this.toStorageType(((ArrayType)type).getElementType()));
        } else if (type instanceof MapType) {
            storageType = this.mapType(this.toStorageType(((MapType)type).getKeyType()), this.toStorageType(((MapType)type).getValueType()));
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type not supported: " + type);
        }
        Preconditions.checkState((boolean)storageType.getJavaType().equals(type.getJavaType()));
        return storageType;
    }

    public Map<Integer, Type> toStorageTypes(Map<Integer, Type> includedColumns) {
        return (Map)includedColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.toStorageType((Type)entry.getValue())));
    }

    private Type mapType(Type keyType, Type valueType) {
        return this.typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
    }
}

