/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage.organization;

import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.MetadataDao;
import com.facebook.presto.raptor.metadata.ShardManager;
import com.facebook.presto.raptor.storage.organization.JobFactory;
import com.facebook.presto.raptor.storage.organization.OrganizationJob;
import com.facebook.presto.raptor.storage.organization.OrganizationSet;
import com.facebook.presto.raptor.storage.organization.ShardCompactor;
import com.facebook.presto.raptor.util.DatabaseUtil;
import java.util.Objects;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class OrganizationJobFactory
implements JobFactory {
    private final MetadataDao metadataDao;
    private final ShardManager shardManager;
    private final ShardCompactor compactor;

    @Inject
    public OrganizationJobFactory(@ForMetadata IDBI dbi, ShardManager shardManager, ShardCompactor compactor) {
        Objects.requireNonNull(dbi, "dbi is null");
        this.metadataDao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.compactor = Objects.requireNonNull(compactor, "compactor is null");
    }

    @Override
    public Runnable create(OrganizationSet organizationSet) {
        return new OrganizationJob(organizationSet, this.metadataDao, this.shardManager, this.compactor);
    }
}

