/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.systemtables;

import com.facebook.presto.common.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import javax.annotation.Nullable;

public class ValueBuffer {
    private final int columnIndex;
    private final Type type;
    private final Object value;

    private ValueBuffer(int columnIndex, Type type, @Nullable Object value) {
        Preconditions.checkArgument((columnIndex >= 0 ? 1 : 0) != 0, (Object)"columnIndex must be > 0");
        this.columnIndex = columnIndex;
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = value;
    }

    public static ValueBuffer create(int columnIndex, Type type, @Nullable Object value) {
        if (value == null) {
            return new ValueBuffer(columnIndex, type, null);
        }
        return new ValueBuffer(columnIndex, type, ValueBuffer.normalizeValue(type, value));
    }

    private static Object normalizeValue(Type type, @Nullable Object value) {
        if (value == null) {
            return value;
        }
        Class javaType = type.getJavaType();
        if (javaType.isPrimitive()) {
            Preconditions.checkArgument((boolean)Primitives.wrap((Class)javaType).isInstance(value), (String)"Type %s incompatible with %s", (Object)type, (Object)value);
            return value;
        }
        if (javaType == Slice.class) {
            if (value instanceof Slice) {
                return value;
            }
            if (value instanceof String) {
                return Slices.utf8Slice((String)((String)value));
            }
            if (value instanceof byte[]) {
                return Slices.wrappedBuffer((byte[])((byte[])value));
            }
        }
        throw new IllegalArgumentException(String.format("Type %s incompatible with %s", type, value));
    }

    @Nullable
    public Object getValue() {
        Preconditions.checkState((!this.isNull() ? 1 : 0) != 0);
        return this.value;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public long getLong() {
        Preconditions.checkState((!this.isNull() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.type.getJavaType() == Long.TYPE ? 1 : 0) != 0, (String)"Type %s cannot be read as long", (Object)this.type);
        return (Long)this.value;
    }

    public double getDouble() {
        Preconditions.checkState((!this.isNull() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.type.getJavaType() == Double.TYPE ? 1 : 0) != 0, (String)"Type %s cannot be read as double", (Object)this.type);
        return (Double)this.value;
    }

    public boolean getBoolean() {
        Preconditions.checkState((!this.isNull() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.type.getJavaType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Type %s cannot be read as boolean", (Object)this.type);
        return (Boolean)this.value;
    }

    public Slice getSlice() {
        Preconditions.checkState((!this.isNull() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.type.getJavaType() == Slice.class ? 1 : 0) != 0, (String)"Type %s cannot be read as Slice", (Object)this.type);
        return (Slice)this.value;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueBuffer that = (ValueBuffer)o;
        return Objects.equals(this.columnIndex, that.columnIndex) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.columnIndex, this.type, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnIndex", this.columnIndex).add("type", (Object)this.type).add("value", this.value).toString();
    }
}

