/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.delta.DeltaColumnHandle;
import com.facebook.presto.delta.DeltaErrorCode;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DeltaPageSource
implements ConnectorPageSource {
    private final List<DeltaColumnHandle> columnHandles;
    private final ConnectorPageSource dataPageSource;
    private final Map<String, Block> partitionValues;

    public DeltaPageSource(List<DeltaColumnHandle> columnHandles, Map<String, Block> partitionValues, ConnectorPageSource dataPageSource) {
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.partitionValues = Objects.requireNonNull(partitionValues, "partitionValues is null");
        this.dataPageSource = Objects.requireNonNull(dataPageSource, "dataPageSource is null");
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.dataPageSource.getNextPage();
            if (dataPage == null) {
                return null;
            }
            int positionCount = dataPage.getPositionCount();
            int dataColumnIndex = 0;
            int columnIndex = 0;
            Block[] blocksWithPartitionColumns = new Block[this.columnHandles.size()];
            for (DeltaColumnHandle columnHandle : this.columnHandles) {
                if (columnHandle.getColumnType() == DeltaColumnHandle.ColumnType.PARTITION) {
                    Block partitionValue = this.partitionValues.get(columnHandle.getName());
                    blocksWithPartitionColumns[columnIndex++] = new RunLengthEncodedBlock(partitionValue, positionCount);
                    continue;
                }
                blocksWithPartitionColumns[columnIndex++] = dataPage.getBlock(dataColumnIndex);
                ++dataColumnIndex;
            }
            return new Page(positionCount, blocksWithPartitionColumns);
        }
        catch (PrestoException exception) {
            this.closeWithSuppression(exception);
            throw exception;
        }
        catch (RuntimeException exception) {
            this.closeWithSuppression(exception);
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_READ_DATA_ERROR, (Throwable)exception);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (Exception exception) {
                if (exception == throwable) break block2;
                throwable.addSuppressed(exception);
            }
        }
    }

    public long getCompletedBytes() {
        return this.dataPageSource.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.dataPageSource.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.dataPageSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.dataPageSource.isFinished();
    }

    public long getSystemMemoryUsage() {
        return this.dataPageSource.getSystemMemoryUsage();
    }

    public void close() throws IOException {
        this.dataPageSource.close();
    }

    public CompletableFuture<?> isBlocked() {
        return this.dataPageSource.isBlocked();
    }

    public RuntimeStats getRuntimeStats() {
        return this.dataPageSource.getRuntimeStats();
    }
}

