/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.delta.DeltaConfig;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public final class DeltaSessionProperties {
    private static final String CACHE_ENABLED = "cache_enabled";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_BATCH_READ_OPTIMIZATION_ENABLED = "parquet_batch_read_optimization_enabled";
    private static final String PARQUET_BATCH_READER_VERIFICATION_ENABLED = "parquet_batch_reader_verification_enabled";
    public static final String PARQUET_DEREFERENCE_PUSHDOWN_ENABLED = "parquet_dereference_pushdown_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public DeltaSessionProperties(DeltaConfig deltaConfigConfig, HiveClientConfig hiveClientConfig, CacheConfig cacheConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)CACHE_ENABLED, (String)"Enable cache for Delta tables", (Boolean)cacheConfig.isCachingEnabled(), (boolean)false), (Object)HiveSessionProperties.dataSizeSessionProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)hiveClientConfig.getParquetMaxReadBlockSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READ_OPTIMIZATION_ENABLED, (String)"Is Parquet batch read optimization enabled", (Boolean)hiveClientConfig.isParquetBatchReadOptimizationEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READER_VERIFICATION_ENABLED, (String)"Is Parquet batch reader verification enabled? This is for testing purposes only, not to be used in production", (Boolean)hiveClientConfig.isParquetBatchReaderVerificationEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_DEREFERENCE_PUSHDOWN_ENABLED, (String)"Is dereference pushdown expression pushdown into Parquet reader enabled?", (Boolean)deltaConfigConfig.isParquetDereferencePushdownEnabled(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(CACHE_ENABLED, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean isParquetBatchReadsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_BATCH_READ_OPTIMIZATION_ENABLED, Boolean.class);
    }

    public static boolean isParquetBatchReaderVerificationEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_BATCH_READER_VERIFICATION_ENABLED, Boolean.class);
    }

    public static boolean isParquetDereferencePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_DEREFERENCE_PUSHDOWN_ENABLED, Boolean.class);
    }
}

