/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HiveBasicStatistics {
    private final OptionalLong fileCount;
    private final OptionalLong rowCount;
    private final OptionalLong inMemoryDataSizeInBytes;
    private final OptionalLong onDiskDataSizeInBytes;

    public static HiveBasicStatistics createEmptyStatistics() {
        return new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty());
    }

    public static HiveBasicStatistics createZeroStatistics() {
        return new HiveBasicStatistics(0L, 0L, 0L, 0L);
    }

    public HiveBasicStatistics(long fileCount, long rowCount, long inMemoryDataSizeInBytes, long onDiskDataSizeInBytes) {
        this(OptionalLong.of(fileCount), OptionalLong.of(rowCount), OptionalLong.of(inMemoryDataSizeInBytes), OptionalLong.of(onDiskDataSizeInBytes));
    }

    @JsonCreator
    public HiveBasicStatistics(@JsonProperty(value="fileCount") OptionalLong fileCount, @JsonProperty(value="rowCount") OptionalLong rowCount, @JsonProperty(value="inMemoryDataSizeInBytes") OptionalLong inMemoryDataSizeInBytes, @JsonProperty(value="onDiskDataSizeInBytes") OptionalLong onDiskDataSizeInBytes) {
        this.fileCount = Objects.requireNonNull(fileCount, "fileCount is null");
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount is null");
        this.inMemoryDataSizeInBytes = Objects.requireNonNull(inMemoryDataSizeInBytes, "inMemoryDataSizeInBytes is null");
        this.onDiskDataSizeInBytes = Objects.requireNonNull(onDiskDataSizeInBytes, "onDiskDataSizeInBytes is null");
    }

    @JsonProperty
    public OptionalLong getFileCount() {
        return this.fileCount;
    }

    @JsonProperty
    public OptionalLong getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    public OptionalLong getInMemoryDataSizeInBytes() {
        return this.inMemoryDataSizeInBytes;
    }

    @JsonProperty
    public OptionalLong getOnDiskDataSizeInBytes() {
        return this.onDiskDataSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBasicStatistics that = (HiveBasicStatistics)o;
        return Objects.equals(this.fileCount, that.fileCount) && Objects.equals(this.rowCount, that.rowCount) && Objects.equals(this.inMemoryDataSizeInBytes, that.inMemoryDataSizeInBytes) && Objects.equals(this.onDiskDataSizeInBytes, that.onDiskDataSizeInBytes);
    }

    public int hashCode() {
        return Objects.hash(this.fileCount, this.rowCount, this.inMemoryDataSizeInBytes, this.onDiskDataSizeInBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileCount", (Object)this.fileCount).add("rowCount", (Object)this.rowCount).add("inMemoryDataSizeInBytes", (Object)this.inMemoryDataSizeInBytes).add("onDiskDataSizeInBytes", (Object)this.onDiskDataSizeInBytes).toString();
    }
}

