/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePageSinkMetadata;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.SchemaTableName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HivePageSinkMetadataProvider {
    private final ExtendedHiveMetastore delegate;
    private final SchemaTableName schemaTableName;
    private final Optional<Table> table;
    private final Map<List<String>, Optional<Partition>> modifiedPartitions;
    private final MetastoreContext metastoreContext;

    public HivePageSinkMetadataProvider(HivePageSinkMetadata pageSinkMetadata, ExtendedHiveMetastore delegate, MetastoreContext metastoreContext) {
        Objects.requireNonNull(pageSinkMetadata, "pageSinkMetadata is null");
        this.delegate = delegate;
        this.schemaTableName = pageSinkMetadata.getSchemaTableName();
        this.table = pageSinkMetadata.getTable();
        this.modifiedPartitions = pageSinkMetadata.getModifiedPartitions();
        this.metastoreContext = Objects.requireNonNull(metastoreContext, "metastoreContext is null");
    }

    public Optional<Table> getTable() {
        return this.table;
    }

    public Optional<Partition> getPartition(List<String> partitionValues) {
        if (!this.table.isPresent() || this.table.get().getPartitionColumns().isEmpty()) {
            throw new IllegalArgumentException(String.format("Unexpected call to getPartition. Table name: %s", this.schemaTableName));
        }
        Optional<Partition> modifiedPartition = this.modifiedPartitions.get(partitionValues);
        if (modifiedPartition == null) {
            return this.delegate.getPartition(this.metastoreContext, this.schemaTableName.getSchemaName(), this.schemaTableName.getTableName(), partitionValues);
        }
        return modifiedPartition;
    }
}

