/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.metastore.BooleanStatistics;
import com.facebook.presto.hive.metastore.DateStatistics;
import com.facebook.presto.hive.metastore.DecimalStatistics;
import com.facebook.presto.hive.metastore.DoubleStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.IntegerStatistics;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;

public final class Statistics {
    private Statistics() {
    }

    public static PartitionStatistics merge(PartitionStatistics first, PartitionStatistics second) {
        return new PartitionStatistics(Statistics.reduce(first.getBasicStatistics(), second.getBasicStatistics(), ReduceOperator.ADD), Statistics.merge(first.getColumnStatistics(), second.getColumnStatistics()));
    }

    public static HiveBasicStatistics reduce(HiveBasicStatistics first, HiveBasicStatistics second, ReduceOperator operator) {
        return new HiveBasicStatistics(Statistics.reduce(first.getFileCount(), second.getFileCount(), operator, false), Statistics.reduce(first.getRowCount(), second.getRowCount(), operator, false), Statistics.reduce(first.getInMemoryDataSizeInBytes(), second.getInMemoryDataSizeInBytes(), operator, false), Statistics.reduce(first.getOnDiskDataSizeInBytes(), second.getOnDiskDataSizeInBytes(), operator, false));
    }

    public static Map<String, HiveColumnStatistics> merge(Map<String, HiveColumnStatistics> first, Map<String, HiveColumnStatistics> second) {
        Sets.SetView columns = Sets.intersection(first.keySet(), second.keySet());
        return (Map)columns.stream().collect(ImmutableMap.toImmutableMap(column -> column, column -> Statistics.merge((HiveColumnStatistics)first.get(column), (HiveColumnStatistics)second.get(column))));
    }

    public static HiveColumnStatistics merge(HiveColumnStatistics first, HiveColumnStatistics second) {
        return new HiveColumnStatistics(Statistics.mergeIntegerStatistics(first.getIntegerStatistics(), second.getIntegerStatistics()), Statistics.mergeDoubleStatistics(first.getDoubleStatistics(), second.getDoubleStatistics()), Statistics.mergeDecimalStatistics(first.getDecimalStatistics(), second.getDecimalStatistics()), Statistics.mergeDateStatistics(first.getDateStatistics(), second.getDateStatistics()), Statistics.mergeBooleanStatistics(first.getBooleanStatistics(), second.getBooleanStatistics()), Statistics.reduce(first.getMaxValueSizeInBytes(), second.getMaxValueSizeInBytes(), ReduceOperator.MAX, true), Statistics.reduce(first.getTotalSizeInBytes(), second.getTotalSizeInBytes(), ReduceOperator.ADD, true), Statistics.reduce(first.getNullsCount(), second.getNullsCount(), ReduceOperator.ADD, false), Statistics.reduce(first.getDistinctValuesCount(), second.getDistinctValuesCount(), ReduceOperator.MAX, false));
    }

    private static Optional<IntegerStatistics> mergeIntegerStatistics(Optional<IntegerStatistics> first, Optional<IntegerStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new IntegerStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DoubleStatistics> mergeDoubleStatistics(Optional<DoubleStatistics> first, Optional<DoubleStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DoubleStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DecimalStatistics> mergeDecimalStatistics(Optional<DecimalStatistics> first, Optional<DecimalStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DecimalStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DateStatistics> mergeDateStatistics(Optional<DateStatistics> first, Optional<DateStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DateStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<BooleanStatistics> mergeBooleanStatistics(Optional<BooleanStatistics> first, Optional<BooleanStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new BooleanStatistics(Statistics.reduce(first.get().getTrueCount(), second.get().getTrueCount(), ReduceOperator.ADD, false), Statistics.reduce(first.get().getFalseCount(), second.get().getFalseCount(), ReduceOperator.ADD, false)));
        }
        return Optional.empty();
    }

    private static OptionalLong reduce(OptionalLong first, OptionalLong second, ReduceOperator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            switch (operator) {
                case ADD: {
                    return OptionalLong.of(first.getAsLong() + second.getAsLong());
                }
                case SUBTRACT: {
                    return OptionalLong.of(first.getAsLong() - second.getAsLong());
                }
                case MAX: {
                    return OptionalLong.of(Statistics.max(first.getAsLong(), second.getAsLong()));
                }
                case MIN: {
                    return OptionalLong.of(Statistics.min(first.getAsLong(), second.getAsLong()));
                }
            }
            throw new IllegalArgumentException("Unexpected operator: " + (Object)((Object)operator));
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return OptionalLong.empty();
    }

    private static OptionalDouble reduce(OptionalDouble first, OptionalDouble second, ReduceOperator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            switch (operator) {
                case ADD: {
                    return OptionalDouble.of(first.getAsDouble() + second.getAsDouble());
                }
                case SUBTRACT: {
                    return OptionalDouble.of(first.getAsDouble() - second.getAsDouble());
                }
                case MAX: {
                    return OptionalDouble.of(Statistics.max(first.getAsDouble(), second.getAsDouble()));
                }
                case MIN: {
                    return OptionalDouble.of(Statistics.min(first.getAsDouble(), second.getAsDouble()));
                }
            }
            throw new IllegalArgumentException("Unexpected operator: " + (Object)((Object)operator));
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return OptionalDouble.empty();
    }

    private static <T extends Comparable<? super T>> Optional<T> reduce(Optional<T> first, Optional<T> second, ReduceOperator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            switch (operator) {
                case MAX: {
                    return Optional.of(Statistics.max((Comparable)first.get(), (Comparable)second.get()));
                }
                case MIN: {
                    return Optional.of(Statistics.min((Comparable)first.get(), (Comparable)second.get()));
                }
            }
            throw new IllegalArgumentException("Unexpected operator: " + (Object)((Object)operator));
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return Optional.empty();
    }

    private static <T extends Comparable<? super T>> T max(T first, T second) {
        return first.compareTo(second) >= 0 ? first : second;
    }

    private static <T extends Comparable<? super T>> T min(T first, T second) {
        return first.compareTo(second) <= 0 ? first : second;
    }

    public static PartitionStatistics createEmptyPartitionStatistics(Map<String, Type> columnTypes, Map<String, Set<ColumnStatisticType>> columnStatisticsMetadataTypes) {
        Map columnStatistics = (Map)columnStatisticsMetadataTypes.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Statistics.createColumnStatisticsForEmptyPartition((Type)columnTypes.get(entry.getKey()), (Set)entry.getValue())));
        return new PartitionStatistics(HiveBasicStatistics.createZeroStatistics(), columnStatistics);
    }

    private static HiveColumnStatistics createColumnStatisticsForEmptyPartition(Type columnType, Set<ColumnStatisticType> columnStatisticTypes) {
        Objects.requireNonNull(columnType, "columnType is null");
        HiveColumnStatistics.Builder result = HiveColumnStatistics.builder();
        block8: for (ColumnStatisticType columnStatisticType : columnStatisticTypes) {
            switch (columnStatisticType) {
                case MAX_VALUE_SIZE_IN_BYTES: {
                    result.setMaxValueSizeInBytes(0L);
                    continue block8;
                }
                case TOTAL_SIZE_IN_BYTES: {
                    result.setTotalSizeInBytes(0L);
                    continue block8;
                }
                case NUMBER_OF_DISTINCT_VALUES: {
                    result.setDistinctValuesCount(0L);
                    continue block8;
                }
                case NUMBER_OF_NON_NULL_VALUES: {
                    result.setNullsCount(0L);
                    continue block8;
                }
                case NUMBER_OF_TRUE_VALUES: {
                    result.setBooleanStatistics(new BooleanStatistics(OptionalLong.of(0L), OptionalLong.of(0L)));
                    continue block8;
                }
                case MIN_VALUE: 
                case MAX_VALUE: {
                    Statistics.setMinMaxForEmptyPartition(columnType, result);
                    continue block8;
                }
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_COLUMN_STATISTIC_TYPE, "Unknown column statistics type: " + columnStatisticType.name());
        }
        return result.build();
    }

    private static void setMinMaxForEmptyPartition(Type type, HiveColumnStatistics.Builder result) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            result.setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty()));
        } else if (type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL)) {
            result.setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        } else if (type.equals(DateType.DATE)) {
            result.setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty()));
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            result.setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty()));
        } else if (type instanceof DecimalType) {
            result.setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty()));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }

    public static Map<List<String>, ComputedStatistics> createComputedStatisticsToPartitionMap(Collection<ComputedStatistics> computedStatistics, List<String> partitionColumns, Map<String, Type> columnTypes) {
        List partitionColumnTypes = (List)partitionColumns.stream().map(columnTypes::get).collect(ImmutableList.toImmutableList());
        return (Map)computedStatistics.stream().collect(ImmutableMap.toImmutableMap(statistics -> Statistics.getPartitionValues(statistics, partitionColumns, partitionColumnTypes), statistics -> statistics));
    }

    private static List<String> getPartitionValues(ComputedStatistics statistics, List<String> partitionColumns, List<Type> partitionColumnTypes) {
        Preconditions.checkArgument((boolean)statistics.getGroupingColumns().equals(partitionColumns), (String)"Unexpected grouping. Partition columns: %s. Grouping columns: %s", partitionColumns, (Object)statistics.getGroupingColumns());
        Page partitionColumnsPage = new Page(1, statistics.getGroupingValues().toArray(new Block[0]));
        return MetastoreUtil.createPartitionValues(partitionColumnTypes, partitionColumnsPage, 0);
    }

    public static Map<String, HiveColumnStatistics> fromComputedStatistics(ConnectorSession session, DateTimeZone timeZone, Map<ColumnStatisticMetadata, Block> computedStatistics, Map<String, Type> columnTypes, long rowCount) {
        return (Map)Statistics.createColumnToComputedStatisticsMap(computedStatistics).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Statistics.createHiveColumnStatistics(session, timeZone, (Map)entry.getValue(), (Type)columnTypes.get(entry.getKey()), rowCount)));
    }

    private static Map<String, Map<ColumnStatisticType, Block>> createColumnToComputedStatisticsMap(Map<ColumnStatisticMetadata, Block> computedStatistics) {
        HashMap result = new HashMap();
        computedStatistics.forEach((metadata, block) -> {
            Map columnStatistics = result.computeIfAbsent(metadata.getColumnName(), key -> new HashMap());
            columnStatistics.put(metadata.getStatisticType(), block);
        });
        return (Map)result.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
    }

    private static HiveColumnStatistics createHiveColumnStatistics(ConnectorSession session, DateTimeZone timeZone, Map<ColumnStatisticType, Block> computedStatistics, Type columnType, long rowCount) {
        HiveColumnStatistics.Builder result = HiveColumnStatistics.builder();
        Verify.verify((computedStatistics.containsKey(ColumnStatisticType.MIN_VALUE) == computedStatistics.containsKey(ColumnStatisticType.MAX_VALUE) ? 1 : 0) != 0);
        if (computedStatistics.containsKey(ColumnStatisticType.MIN_VALUE)) {
            Statistics.setMinMax(session, timeZone, columnType, computedStatistics.get(ColumnStatisticType.MIN_VALUE), computedStatistics.get(ColumnStatisticType.MAX_VALUE), result);
        }
        if (computedStatistics.containsKey(ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES)) {
            result.setMaxValueSizeInBytes(Statistics.getIntegerValue(session, (Type)BigintType.BIGINT, computedStatistics.get(ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES)));
        }
        if (computedStatistics.containsKey(ColumnStatisticType.TOTAL_SIZE_IN_BYTES)) {
            result.setTotalSizeInBytes(Statistics.getIntegerValue(session, (Type)BigintType.BIGINT, computedStatistics.get(ColumnStatisticType.TOTAL_SIZE_IN_BYTES)));
        }
        if (computedStatistics.containsKey(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            result.setNullsCount(rowCount - BigintType.BIGINT.getLong(computedStatistics.get(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0));
        }
        if (computedStatistics.containsKey(ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES) && computedStatistics.containsKey(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            long numberOfNonNullValues = BigintType.BIGINT.getLong(computedStatistics.get(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0);
            long numberOfDistinctValues = BigintType.BIGINT.getLong(computedStatistics.get(ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), 0);
            if (numberOfDistinctValues > numberOfNonNullValues) {
                result.setDistinctValuesCount(numberOfNonNullValues);
            } else {
                result.setDistinctValuesCount(numberOfDistinctValues);
            }
        }
        if (computedStatistics.containsKey(ColumnStatisticType.NUMBER_OF_TRUE_VALUES) && computedStatistics.containsKey(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            long numberOfTrue = BigintType.BIGINT.getLong(computedStatistics.get(ColumnStatisticType.NUMBER_OF_TRUE_VALUES), 0);
            long numberOfNonNullValues = BigintType.BIGINT.getLong(computedStatistics.get(ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0);
            result.setBooleanStatistics(new BooleanStatistics(OptionalLong.of(numberOfTrue), OptionalLong.of(numberOfNonNullValues - numberOfTrue)));
        }
        return result.build();
    }

    private static void setMinMax(ConnectorSession session, DateTimeZone timeZone, Type type, Block min, Block max, HiveColumnStatistics.Builder result) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            result.setIntegerStatistics(new IntegerStatistics(Statistics.getIntegerValue(session, type, min), Statistics.getIntegerValue(session, type, max)));
        } else if (type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL)) {
            result.setDoubleStatistics(new DoubleStatistics(Statistics.getDoubleValue(session, type, min), Statistics.getDoubleValue(session, type, max)));
        } else if (type.equals(DateType.DATE)) {
            result.setDateStatistics(new DateStatistics(Statistics.getDateValue(session, type, min), Statistics.getDateValue(session, type, max)));
        } else if (type.equals(TimestampType.TIMESTAMP)) {
            result.setIntegerStatistics(new IntegerStatistics(Statistics.getTimestampValue(timeZone, min), Statistics.getTimestampValue(timeZone, max)));
        } else if (type instanceof DecimalType) {
            result.setDecimalStatistics(new DecimalStatistics(Statistics.getDecimalValue(session, type, min), Statistics.getDecimalValue(session, type, max)));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }

    private static OptionalLong getIntegerValue(ConnectorSession session, Type type, Block block) {
        return block.isNull(0) ? OptionalLong.empty() : OptionalLong.of(((Number)type.getObjectValue(session.getSqlFunctionProperties(), block, 0)).longValue());
    }

    private static OptionalDouble getDoubleValue(ConnectorSession session, Type type, Block block) {
        return block.isNull(0) ? OptionalDouble.empty() : OptionalDouble.of(((Number)type.getObjectValue(session.getSqlFunctionProperties(), block, 0)).doubleValue());
    }

    private static Optional<LocalDate> getDateValue(ConnectorSession session, Type type, Block block) {
        return block.isNull(0) ? Optional.empty() : Optional.of(LocalDate.ofEpochDay(((SqlDate)type.getObjectValue(session.getSqlFunctionProperties(), block, 0)).getDays()));
    }

    private static OptionalLong getTimestampValue(DateTimeZone timeZone, Block block) {
        return block.isNull(0) ? OptionalLong.empty() : OptionalLong.of(TimeUnit.MILLISECONDS.toSeconds(timeZone.convertUTCToLocal(block.getLong(0))));
    }

    private static Optional<BigDecimal> getDecimalValue(ConnectorSession session, Type type, Block block) {
        return block.isNull(0) ? Optional.empty() : Optional.of(((SqlDecimal)type.getObjectValue(session.getSqlFunctionProperties(), block, 0)).toBigDecimal());
    }

    public static enum ReduceOperator {
        ADD,
        SUBTRACT,
        MIN,
        MAX;

    }
}

