/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.thrift;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.PartitionNotFoundException;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.SchemaAlreadyExistsException;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastoreStats;
import com.facebook.presto.hive.metastore.thrift.ThriftMetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.security.RoleGrant;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.thrift.TException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ThriftHiveMetastore
implements HiveMetastore {
    private static final String DEFAULT_METASTORE_USER = "presto";
    private static final HdfsContext hdfsContext = new HdfsContext(new ConnectorIdentity("presto", Optional.empty(), Optional.empty()));
    private final ThriftHiveMetastoreStats stats;
    private final HiveCluster clientProvider;
    private final Function<Exception, Exception> exceptionMapper;
    private final HdfsEnvironment hdfsEnvironment;
    private final boolean impersonationEnabled;
    private final boolean isMetastoreAuthenticationEnabled;
    private final boolean deleteFilesOnTableDrop;

    @Inject
    public ThriftHiveMetastore(HiveCluster hiveCluster, MetastoreClientConfig config, HdfsEnvironment hdfsEnvironment) {
        this(hiveCluster, new ThriftHiveMetastoreStats(), Function.identity(), hdfsEnvironment, Objects.requireNonNull(config, "config is null").isMetastoreImpersonationEnabled(), Objects.requireNonNull(config, "config is null").isDeleteFilesOnTableDrop(), Objects.requireNonNull(config, "config is null").getHiveMetastoreAuthenticationType() != MetastoreClientConfig.HiveMetastoreAuthenticationType.NONE);
    }

    public ThriftHiveMetastore(HiveCluster hiveCluster, ThriftHiveMetastoreStats stats, Function<Exception, Exception> exceptionMapper, HdfsEnvironment hdfsEnvironment, boolean impersonationEnabled, boolean deleteFilesOnTableDrop, boolean isMetastoreAuthenticationEnabled) {
        this.clientProvider = Objects.requireNonNull(hiveCluster, "hiveCluster is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper is null");
        this.impersonationEnabled = impersonationEnabled;
        this.deleteFilesOnTableDrop = deleteFilesOnTableDrop;
        this.isMetastoreAuthenticationEnabled = isMetastoreAuthenticationEnabled;
    }

    private static boolean isPrestoView(org.apache.hadoop.hive.metastore.api.Table table) {
        return "true".equals(table.getParameters().get("presto_view"));
    }

    @Managed
    @Flatten
    public ThriftHiveMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public List<String> getAllDatabases(MetastoreContext context) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> this.getMetastoreClientThenCall(context, HiveMetastoreClient::getAllDatabases)));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> Optional.of(client.getDatabase(databaseName)))));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getAllTables(MetastoreContext metastoreContext, String databaseName) {
        Callable<List> getAllTables = this.stats.getGetAllTables().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> client.getAllTables(databaseName)));
        Callable<Void> getDatabase = this.stats.getGetDatabase().wrap(() -> {
            this.getMetastoreClientThenCall(metastoreContext, client -> client.getDatabase(databaseName));
            return null;
        });
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                List tables = (List)getAllTables.call();
                if (tables.isEmpty()) {
                    getDatabase.call();
                }
                return Optional.of(tables);
            });
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<org.apache.hadoop.hive.metastore.api.Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                org.apache.hadoop.hive.metastore.api.Table table = client.getTable(databaseName, tableName);
                if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name()) && !ThriftHiveMetastore.isPrestoView(table)) {
                    throw new HiveViewNotSupportedException(new SchemaTableName(databaseName, tableName));
                }
                return Optional.of(table);
            })));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(MetastoreContext metastoreContext, Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.NUMBER_OF_TRUE_VALUES);
        }
        if (TypeUtils.isNumericType((Type)type) || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP)) {
            return ImmutableSet.of((Object)ColumnStatisticType.MIN_VALUE, (Object)ColumnStatisticType.MAX_VALUE, (Object)ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES, (Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES);
        }
        if (Varchars.isVarcharType((Type)type) || Chars.isCharType((Type)type)) {
            return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES, (Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES, (Object)ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES);
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return ImmutableSet.of((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES, (Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES, (Object)ColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES);
        }
        if (type instanceof ArrayType || type instanceof RowType || type instanceof MapType) {
            return ImmutableSet.of();
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Override
    public PartitionStatistics getTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName) {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTable(metastoreContext, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        HiveBasicStatistics basicStatistics = MetastoreUtil.getHiveBasicStatistics(table.getParameters());
        Map<String, HiveColumnStatistics> columnStatistics = this.getTableColumnStatistics(metastoreContext, databaseName, tableName, dataColumns, basicStatistics.getRowCount());
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private Map<String, HiveColumnStatistics> getTableColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> columns, OptionalLong rowCount) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTableColumnStatistics", this.stats.getGetTableColumnStatistics().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> this.groupStatisticsByColumn(client.getTableColumnStatistics(databaseName, tableName, columns), rowCount))));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTable(metastoreContext, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        List partitionColumns = (List)table.getPartitionKeys().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        Map partitionBasicStatistics = (Map)this.getPartitionsByNames(metastoreContext, databaseName, tableName, (List<String>)ImmutableList.copyOf(partitionNames)).stream().collect(ImmutableMap.toImmutableMap(partition -> FileUtils.makePartName((List)partitionColumns, (List)partition.getValues()), partition -> MetastoreUtil.getHiveBasicStatistics(partition.getParameters())));
        Map partitionRowCounts = (Map)partitionBasicStatistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((HiveBasicStatistics)entry.getValue()).getRowCount()));
        Map<String, Map<String, HiveColumnStatistics>> partitionColumnStatistics = this.getPartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionNames, dataColumns, partitionRowCounts);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String partitionName : partitionNames) {
            HiveBasicStatistics basicStatistics = partitionBasicStatistics.getOrDefault(partitionName, HiveBasicStatistics.createEmptyStatistics());
            Map<String, HiveColumnStatistics> columnStatistics = partitionColumnStatistics.getOrDefault(partitionName, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
            result.put((Object)partitionName, (Object)new PartitionStatistics(basicStatistics, columnStatistics));
        }
        return result.build();
    }

    @Override
    public Optional<List<FieldSchema>> getFields(MetastoreContext metastoreContext, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(MetaException.class, UnknownTableException.class, UnknownDBException.class).stopOnIllegalExceptions().run("getFields", this.stats.getGetFields().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> Optional.of(ImmutableList.copyOf(client.getFields(databaseName, tableName))))));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames, Map<String, OptionalLong> partitionRowCounts) {
        return (Map)this.getMetastorePartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionNames, columnNames).entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.groupStatisticsByColumn((List)entry.getValue(), partitionRowCounts.getOrDefault(entry.getKey(), OptionalLong.empty()))));
    }

    private Map<String, List<ColumnStatisticsObj>> getMetastorePartitionColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getPartitionColumnStatistics", this.stats.getGetPartitionColumnStatistics().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> client.getPartitionColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)partitionNames), columnNames))));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, HiveColumnStatistics> groupStatisticsByColumn(List<ColumnStatisticsObj> statistics, OptionalLong rowCount) {
        return (Map)statistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsObj::getColName, statisticsObj -> ThriftMetastoreUtil.fromMetastoreApiColumnStatistics(statisticsObj, rowCount)));
    }

    @Override
    public synchronized void updateTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionStatistics currentStatistics = this.getTableStatistics(metastoreContext, databaseName, tableName);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        org.apache.hadoop.hive.metastore.api.Table originalTable = this.getTable(metastoreContext, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        org.apache.hadoop.hive.metastore.api.Table modifiedTable = originalTable.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedTable.setParameters(MetastoreUtil.updateStatisticsParameters(modifiedTable.getParameters(), basicStatistics));
        this.alterTable(metastoreContext, databaseName, tableName, modifiedTable);
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable(modifiedTable, metastoreContext.getColumnConverter());
        OptionalLong rowCount = basicStatistics.getRowCount();
        List metastoreColumnStatistics = (List)updatedStatistics.getColumnStatistics().entrySet().stream().map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), table.getColumn((String)entry.getKey()).get().getType(), (HiveColumnStatistics)entry.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setTableColumnStatistics(metastoreContext, databaseName, tableName, metastoreColumnStatistics);
        }
        Sets.SetView removedColumnStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedColumnStatistics.forEach(column -> this.deleteTableColumnStatistics(metastoreContext, databaseName, tableName, (String)column));
    }

    private void setTableColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setTableColumnStatistics", this.stats.getUpdateTableColumnStatistics().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.setTableColumnStatistics(databaseName, tableName, statistics);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deleteTableColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deleteTableColumnStatistics", this.stats.getUpdatePartitionColumnStatistics().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.deleteTableColumnStatistics(databaseName, tableName, columnName);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public synchronized void updatePartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionStatistics currentStatistics = Objects.requireNonNull(this.getPartitionStatistics(metastoreContext, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName), "getPartitionStatistics() returned null");
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        List<Partition> partitions = this.getPartitionsByNames(metastoreContext, databaseName, tableName, (List<String>)ImmutableList.of((Object)partitionName));
        if (partitions.size() != 1) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Metastore returned multiple partitions for name: " + partitionName);
        }
        Partition originalPartition = (Partition)Iterables.getOnlyElement(partitions);
        Partition modifiedPartition = originalPartition.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedPartition.setParameters(MetastoreUtil.updateStatisticsParameters(modifiedPartition.getParameters(), basicStatistics));
        this.alterPartitionWithoutStatistics(metastoreContext, databaseName, tableName, modifiedPartition);
        Map columns = (Map)modifiedPartition.getSd().getCols().stream().collect(ImmutableMap.toImmutableMap(FieldSchema::getName, schema -> metastoreContext.getColumnConverter().toColumn((FieldSchema)schema).getType()));
        this.setPartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionName, columns, updatedStatistics.getColumnStatistics(), basicStatistics.getRowCount());
        Sets.SetView removedStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedStatistics.forEach(column -> this.deletePartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionName, (String)column));
    }

    private void setPartitionColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, Map<String, HiveType> columns, Map<String, HiveColumnStatistics> columnStatistics, OptionalLong rowCount) {
        List metastoreColumnStatistics = (List)columnStatistics.entrySet().stream().filter(entry -> columns.containsKey(entry.getKey())).map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), (HiveType)columns.get(entry.getKey()), (HiveColumnStatistics)entry.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setPartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionName, metastoreColumnStatistics);
        }
    }

    private void setPartitionColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setPartitionColumnStatistics", this.stats.getUpdatePartitionColumnStatistics().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.setPartitionColumnStatistics(databaseName, tableName, partitionName, statistics);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deletePartitionColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deletePartitionColumnStatistics", this.stats.getUpdatePartitionColumnStatistics().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.deletePartitionColumnStatistics(databaseName, tableName, partitionName, columnName);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createRole(MetastoreContext metastoreContext, String role, String grantor) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("createRole", this.stats.getCreateRole().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.createRole(role, grantor);
                return null;
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropRole(MetastoreContext metastoreContext, String role) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("dropRole", this.stats.getDropRole().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.dropRole(role);
                return null;
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<String> listRoles(MetastoreContext metastoreContext) {
        try {
            return (Set)this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoles", this.stats.getListRoles().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> ImmutableSet.copyOf(client.getRoleNames()))));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, PrestoPrincipal grantor) {
        for (PrestoPrincipal grantee : grantees) {
            for (String role : roles) {
                this.grantRole(metastoreContext, role, grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), grantor.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantor.getType()), withAdminOption);
            }
        }
    }

    private void grantRole(MetastoreContext metastoreContext, String role, String granteeName, org.apache.hadoop.hive.metastore.api.PrincipalType granteeType, String grantorName, org.apache.hadoop.hive.metastore.api.PrincipalType grantorType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("grantRole", this.stats.getGrantRole().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.grantRole(role, granteeName, granteeType, grantorName, grantorType, grantOption);
                return null;
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeRoles(MetastoreContext metastoreContext, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, PrestoPrincipal grantor) {
        for (PrestoPrincipal grantee : grantees) {
            for (String role : roles) {
                this.revokeRole(metastoreContext, role, grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), adminOptionFor);
            }
        }
    }

    private void revokeRole(MetastoreContext metastoreContext, String role, String granteeName, org.apache.hadoop.hive.metastore.api.PrincipalType granteeType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("revokeRole", this.stats.getRevokeRole().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.revokeRole(role, granteeName, granteeType, grantOption);
                return null;
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(MetastoreContext metastoreContext, PrestoPrincipal principal) {
        try {
            return this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoleGrants", this.stats.getListRoleGrants().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> ThriftMetastoreUtil.fromRolePrincipalGrants(client.listRoleGrants(principal.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(principal.getType()))))));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getAllViews(MetastoreContext metastoreContext, String databaseName) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getGetAllViews().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                String filter = "hive_filter_field_params__presto_view = \"true\"";
                return Optional.of(client.getTableNamesByFilter(databaseName, filter));
            })));
        }
        catch (UnknownDBException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createDatabase(MetastoreContext metastoreContext, Database database) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class).stopOnIllegalExceptions().run("createDatabase", this.stats.getCreateDatabase().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.createDatabase(database);
                return null;
            })));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropDatabase(MetastoreContext metastoreContext, String databaseName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidOperationException.class).stopOnIllegalExceptions().run("dropDatabase", this.stats.getAlterDatabase().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.dropDatabase(databaseName, false, false);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterDatabase(MetastoreContext metastoreContext, String databaseName, Database database) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterDatabase", this.stats.getAlterDatabase().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.alterDatabase(databaseName, database);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public MetastoreOperationResult createTable(MetastoreContext metastoreContext, org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.createTable(table);
                return null;
            })));
            return MetastoreOperationResult.EMPTY_RESULT;
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(table.getDbName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropTable(MetastoreContext metastoreContext, String databaseName, String tableName, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                if (!this.deleteFilesOnTableDrop) {
                    client.dropTable(databaseName, tableName, deleteData);
                } else {
                    org.apache.hadoop.hive.metastore.api.Table table = client.getTable(databaseName, tableName);
                    client.dropTable(databaseName, tableName, deleteData);
                    String tableLocation = table.getSd().getLocation();
                    if (deleteData && MetastoreUtil.isManagedTable(table.getTableType()) && !Strings.isNullOrEmpty((String)tableLocation)) {
                        MetastoreUtil.deleteDirectoryRecursively(hdfsContext, this.hdfsEnvironment, new Path(tableLocation), true);
                    }
                }
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public MetastoreOperationResult alterTable(MetastoreContext metastoreContext, String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTable", this.stats.getAlterTable().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.getTable(metastoreContext, databaseName, tableName);
                if (!source.isPresent()) {
                    throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                }
                client.alterTable(databaseName, tableName, table);
                return null;
            })));
            return MetastoreOperationResult.EMPTY_RESULT;
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNames(MetastoreContext metastoreContext, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> Optional.of(client.getPartitionNames(databaseName, tableName)))));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> parts) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesPs().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> Optional.of(client.getPartitionNamesFiltered(databaseName, tableName, parts)))));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getPartitionNamesByFilter(MetastoreContext metastoreContext, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        List<String> parts = MetastoreUtil.convertPredicateToParts(partitionPredicates);
        return this.getPartitionNamesByParts(metastoreContext, databaseName, tableName, parts).orElse((List<String>)ImmutableList.of());
    }

    @Override
    public MetastoreOperationResult addPartitions(MetastoreContext metastoreContext, String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        List partitions = (List)partitionsWithStatistics.stream().map(part -> ThriftMetastoreUtil.toMetastoreApiPartition(part, metastoreContext.getColumnConverter())).collect(ImmutableList.toImmutableList());
        this.addPartitionsWithoutStatistics(metastoreContext, databaseName, tableName, partitions);
        for (PartitionWithStatistics partitionWithStatistics : partitionsWithStatistics) {
            this.storePartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        }
        return MetastoreOperationResult.EMPTY_RESULT;
    }

    private void addPartitionsWithoutStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class, PrestoException.class).stopOnIllegalExceptions().run("addPartitions", this.stats.getAddPartitions().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                int partitionsAdded = client.addPartitions(partitions);
                if (partitionsAdded != partitions.size()) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, String.format("Hive metastore only added %s of %s partitions", partitionsAdded, partitions.size()));
                }
                return null;
            })));
        }
        catch (AlreadyExistsException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("One or more partitions already exist for table '%s.%s'", databaseName, tableName), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private <V> V getMetastoreClientThenCall(MetastoreContext metastoreContext, MetastoreCallable<V> callable) throws Exception {
        if (!this.impersonationEnabled) {
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient(Optional.empty());){
                V v = callable.call(client);
                return v;
            }
        }
        if (this.isMetastoreAuthenticationEnabled) {
            String token;
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient(Optional.empty());){
                token = client.getDelegationToken(metastoreContext.getUsername(), metastoreContext.getUsername());
            }
            var5_10 = null;
            try (HiveMetastoreClient realClient = this.clientProvider.createMetastoreClient(Optional.of(token));){
                V v = callable.call(realClient);
                return v;
            }
            catch (Throwable throwable) {
                var5_10 = throwable;
                throw throwable;
            }
        }
        HiveMetastoreClient client = this.clientProvider.createMetastoreClient(Optional.empty());
        ThriftHiveMetastore.setMetastoreUserOrClose(client, metastoreContext.getUsername());
        return callable.call(client);
    }

    @Override
    public void dropPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("dropPartition", this.stats.getDropPartition().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.dropPartition(databaseName, tableName, parts, deleteData);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public MetastoreOperationResult alterPartition(MetastoreContext metastoreContext, String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        this.alterPartitionWithoutStatistics(metastoreContext, databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics, metastoreContext.getColumnConverter()));
        this.storePartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        this.dropExtraColumnStatisticsAfterAlterPartition(metastoreContext, databaseName, tableName, partitionWithStatistics);
        return MetastoreOperationResult.EMPTY_RESULT;
    }

    private void alterPartitionWithoutStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Partition partition) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterPartition", this.stats.getAlterPartition().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.alterPartition(databaseName, tableName, partition);
                return null;
            })));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void storePartitionColumnStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, String partitionName, PartitionWithStatistics partitionWithStatistics) {
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        Map<String, HiveColumnStatistics> columnStatistics = statistics.getColumnStatistics();
        if (columnStatistics.isEmpty()) {
            return;
        }
        Map columnTypes = (Map)partitionWithStatistics.getPartition().getColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType));
        this.setPartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionName, columnTypes, columnStatistics, statistics.getBasicStatistics().getRowCount());
    }

    private void dropExtraColumnStatisticsAfterAlterPartition(MetastoreContext metastoreContext, String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        List dataColumns = (List)partitionWithStatistics.getPartition().getColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        HashSet columnsWithMissingStatistics = new HashSet(dataColumns);
        columnsWithMissingStatistics.removeAll(partitionWithStatistics.getStatistics().getColumnStatistics().keySet());
        if (columnsWithMissingStatistics.isEmpty()) {
            return;
        }
        String partitionName = partitionWithStatistics.getPartitionName();
        List<ColumnStatisticsObj> statisticsToBeRemoved = this.getMetastorePartitionColumnStatistics(metastoreContext, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName), (List<String>)ImmutableList.copyOf(columnsWithMissingStatistics)).getOrDefault(partitionName, (List<ColumnStatisticsObj>)ImmutableList.of());
        for (ColumnStatisticsObj statistics : statisticsToBeRemoved) {
            this.deletePartitionColumnStatistics(metastoreContext, databaseName, tableName, partitionName, statistics.getColName());
        }
    }

    @Override
    public Optional<Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartition", this.stats.getGetPartition().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> Optional.of(client.getPartition(databaseName, tableName, partitionValues)))));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<Partition> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> client.getPartitionsByNames(databaseName, tableName, partitionNames))));
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> requestedPrivileges = privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("grantTablePrivileges", this.stats.getGrantTablePrivileges().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                Set<HivePrivilegeInfo> existingPrivileges = this.listTablePrivileges(metastoreContext, databaseName, tableName, grantee);
                HashSet<PrivilegeGrantInfo> privilegesToGrant = new HashSet<PrivilegeGrantInfo>(requestedPrivileges);
                Iterator iterator = privilegesToGrant.iterator();
                while (iterator.hasNext()) {
                    HivePrivilegeInfo requestedPrivilege = (HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege((PrivilegeGrantInfo)iterator.next(), Optional.empty()));
                    for (HivePrivilegeInfo existingPrivilege : existingPrivileges) {
                        if (requestedPrivilege.isContainedIn(existingPrivilege)) {
                            iterator.remove();
                            continue;
                        }
                        if (!existingPrivilege.isContainedIn(requestedPrivilege)) continue;
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Granting %s WITH GRANT OPTION is not supported while %s possesses %s", requestedPrivilege.getHivePrivilege().name(), grantee, requestedPrivilege.getHivePrivilege().name()));
                    }
                }
                if (privilegesToGrant.isEmpty()) {
                    return null;
                }
                return client.grantPrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToGrant));
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        Set<PrivilegeGrantInfo> requestedPrivileges = privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(Collectors.toSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("revokeTablePrivileges", this.stats.getRevokeTablePrivileges().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                Set existingHivePrivileges = this.listTablePrivileges(metastoreContext, databaseName, tableName, grantee).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(Collectors.toSet());
                Set<PrivilegeGrantInfo> privilegesToRevoke = requestedPrivileges.stream().filter(privilegeGrantInfo -> existingHivePrivileges.contains((Object)((HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege(privilegeGrantInfo, Optional.empty()))).getHivePrivilege())).collect(Collectors.toSet());
                if (privilegesToRevoke.isEmpty()) {
                    return null;
                }
                return client.revokePrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToRevoke));
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(MetastoreContext metastoreContext, String databaseName, String tableName, PrestoPrincipal principal) {
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("getListPrivileges", this.stats.getListPrivileges().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                List<HiveObjectPrivilege> hiveObjectPrivilegeList;
                org.apache.hadoop.hive.metastore.api.Table table = client.getTable(databaseName, tableName);
                ImmutableSet.Builder privileges = ImmutableSet.builder();
                if (principal == null) {
                    hiveObjectPrivilegeList = client.listPrivileges(null, null, new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                } else {
                    if (principal.getType() == PrincipalType.USER && table.getOwner().equals(principal.getName())) {
                        privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, principal, principal));
                    }
                    hiveObjectPrivilegeList = client.listPrivileges(principal.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(principal.getType()), new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                }
                for (HiveObjectPrivilege hiveObjectPrivilege : hiveObjectPrivilegeList) {
                    PrestoPrincipal grantee = new PrestoPrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(hiveObjectPrivilege.getPrincipalType()), hiveObjectPrivilege.getPrincipalName());
                    privileges.addAll(ThriftMetastoreUtil.parsePrivilege(hiveObjectPrivilege.getGrantInfo(), Optional.of(grantee)));
                }
                return privileges.build();
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lock(MetastoreContext metastoreContext, String databaseName, String tableName) {
        try {
            LockComponent lockComponent = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, databaseName);
            lockComponent.setTablename(tableName);
            LockRequest lockRequest = new LockRequest((List)Lists.newArrayList((Object[])new LockComponent[]{lockComponent}), metastoreContext.getUsername(), InetAddress.getLocalHost().getHostName());
            LockResponse lockResponse = this.stats.getLock().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> client.lock(lockRequest))).call();
            LockState state = lockResponse.getState();
            long lockId = lockResponse.getLockid();
            AtomicBoolean acquired = new AtomicBoolean(state.equals((Object)LockState.ACQUIRED));
            try {
                if (state.equals((Object)LockState.WAITING)) {
                    this.retry().maxAttempts(2147483547).stopOnIllegalExceptions().exceptionMapper(e -> {
                        if (e instanceof WaitingForLockException) {
                            return e;
                        }
                        return new IllegalStateException(e.getMessage(), (Throwable)e);
                    }).run("lock", this.stats.getLock().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                        LockResponse response = client.checkLock(new CheckLockRequest(lockId));
                        LockState newState = response.getState();
                        if (newState.equals((Object)LockState.WAITING)) {
                            throw new WaitingForLockException("Waiting for lock.");
                        }
                        if (!newState.equals((Object)LockState.ACQUIRED)) {
                            throw new RuntimeException(String.format("Failed to acquire lock: %s", newState.name()));
                        }
                        acquired.set(true);
                        return null;
                    })));
                }
            }
            finally {
                if (!acquired.get()) {
                    this.unlock(metastoreContext, lockId);
                }
            }
            if (!acquired.get()) {
                throw new RuntimeException("Failed to acquire lock");
            }
            return lockId;
        }
        catch (TException e2) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e2);
        }
        catch (Exception e3) {
            throw ThriftHiveMetastore.propagate(e3);
        }
    }

    @Override
    public void unlock(MetastoreContext metastoreContext, long lockId) {
        try {
            this.retry().stopOnIllegalExceptions().run("unlock", this.stats.getUnlock().wrap(() -> this.getMetastoreClientThenCall(metastoreContext, client -> {
                client.unlock(new UnlockRequest(lockId));
                return null;
            })));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private PrivilegeBag buildPrivilegeBag(String databaseName, String tableName, PrestoPrincipal grantee, Set<PrivilegeGrantInfo> privilegeGrantInfos) {
        ImmutableList.Builder privilegeBagBuilder = ImmutableList.builder();
        for (PrivilegeGrantInfo privilegeGrantInfo : privilegeGrantInfos) {
            privilegeBagBuilder.add((Object)new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null), grantee.getName(), ThriftMetastoreUtil.fromPrestoPrincipalType(grantee.getType()), privilegeGrantInfo));
        }
        return new PrivilegeBag((List)privilegeBagBuilder.build());
    }

    private boolean containsAllPrivilege(Set<PrivilegeGrantInfo> requestedPrivileges) {
        return requestedPrivileges.stream().anyMatch(privilege -> privilege.getPrivilege().equalsIgnoreCase("all"));
    }

    private RetryDriver retry() {
        return RetryDriver.retry().exceptionMapper(this.exceptionMapper).stopOn(PrestoException.class);
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }

    private static void setMetastoreUserOrClose(HiveMetastoreClient client, String username) throws TException {
        try {
            client.setUGI(username);
        }
        catch (Throwable t) {
            try {
                HiveMetastoreClient ignored = client;
                Throwable throwable = null;
                try {
                    try {
                        throw t;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class WaitingForLockException
    extends RuntimeException {
        public WaitingForLockException(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    public static interface MetastoreCallable<V> {
        public V call(HiveMetastoreClient var1) throws Exception;
    }
}

