/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GetIndexTemplatesResponse
extends ActionResponse
implements ToXContentObject {
    private List<IndexTemplateMetaData> indexTemplates;

    GetIndexTemplatesResponse() {
    }

    GetIndexTemplatesResponse(List<IndexTemplateMetaData> indexTemplates) {
        this.indexTemplates = indexTemplates;
    }

    public List<IndexTemplateMetaData> getIndexTemplates() {
        return this.indexTemplates;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.indexTemplates = new ArrayList<IndexTemplateMetaData>(size);
        for (int i = 0; i < size; ++i) {
            this.indexTemplates.add(0, IndexTemplateMetaData.readFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indexTemplates.size());
        for (IndexTemplateMetaData indexTemplate : this.indexTemplates) {
            indexTemplate.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        params = new ToXContent.DelegatingMapParams(Collections.singletonMap("reduce_mappings", "true"), params);
        builder.startObject();
        for (IndexTemplateMetaData indexTemplateMetaData : this.getIndexTemplates()) {
            IndexTemplateMetaData.Builder.toXContent(indexTemplateMetaData, builder, params);
        }
        builder.endObject();
        return builder;
    }
}

