/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.drift.client.DriftInvocationHandler;
import com.facebook.drift.client.ExceptionClassification;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.client.ConnectionFailedException;
import com.facebook.drift.transport.client.DriftClientConfig;
import com.facebook.drift.transport.client.MessageTooLargeException;
import com.facebook.drift.transport.client.RequestTimeoutException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RetryPolicy {
    public static final RetryPolicy NO_RETRY_POLICY = new RetryPolicy(0, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 1.0, new Duration(0.0, TimeUnit.MILLISECONDS), ExceptionClassifier.NORMAL_RESULT);
    private final int maxRetries;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;
    private final double backoffScaleFactor;
    private final Duration maxRetryTime;
    private final ExceptionClassifier exceptionClassifier;

    public RetryPolicy(DriftClientConfig config, ExceptionClassifier exceptionClassifier) {
        this(config.getMaxRetries(), config.getMinBackoffDelay(), config.getMaxBackoffDelay(), config.getBackoffScaleFactor(), config.getMaxRetryTime(), exceptionClassifier);
    }

    public RetryPolicy(int maxRetries, Duration minBackoffDelay, Duration maxBackoffDelay, double backoffScaleFactor, Duration maxRetryTime, ExceptionClassifier exceptionClassifier) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be positive");
        this.maxRetries = maxRetries;
        this.minBackoffDelay = Objects.requireNonNull(minBackoffDelay, "minBackoffDelay is null");
        this.maxBackoffDelay = Objects.requireNonNull(maxBackoffDelay, "maxBackoffDelay is null");
        Preconditions.checkArgument((backoffScaleFactor >= 1.0 ? 1 : 0) != 0, (Object)"backoffScaleFactor must be at least 1");
        this.backoffScaleFactor = backoffScaleFactor;
        this.maxRetryTime = Objects.requireNonNull(maxRetryTime, "maxRetryTime is null");
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getBackoffDelay(int invocationAttempts) {
        long delayInMs = (long)((double)this.minBackoffDelay.toMillis() * Math.pow(this.backoffScaleFactor, invocationAttempts - 1));
        return new Duration((double)Math.min(delayInMs, this.maxBackoffDelay.toMillis()), TimeUnit.MILLISECONDS);
    }

    public Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    public ExceptionClassification classifyException(Throwable throwable, boolean idempotent) {
        if (throwable instanceof ConnectionFailedException) {
            return new ExceptionClassification(Optional.of(Boolean.TRUE), ExceptionClassification.HostStatus.DOWN);
        }
        if (throwable instanceof RequestTimeoutException) {
            if (idempotent) {
                return new ExceptionClassification(Optional.of(Boolean.TRUE), ExceptionClassification.HostStatus.NORMAL);
            }
            return new ExceptionClassification(Optional.of(Boolean.FALSE), ExceptionClassification.HostStatus.NORMAL);
        }
        if (throwable instanceof MessageTooLargeException) {
            return new ExceptionClassification(Optional.of(Boolean.FALSE), ExceptionClassification.HostStatus.NORMAL);
        }
        if (throwable instanceof InterruptedException || throwable instanceof InterruptedIOException) {
            return new ExceptionClassification(Optional.of(Boolean.FALSE), ExceptionClassification.HostStatus.NORMAL);
        }
        ExceptionClassification result = this.exceptionClassifier.classifyException(DriftInvocationHandler.unwrapUserException(throwable));
        if (result.isRetry().isPresent()) {
            return result;
        }
        if (throwable instanceof TTransportException) {
            if (idempotent) {
                return new ExceptionClassification(Optional.of(Boolean.TRUE), ExceptionClassification.HostStatus.NORMAL);
            }
            return new ExceptionClassification(Optional.of(Boolean.FALSE), ExceptionClassification.HostStatus.NORMAL);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxAttempts", this.maxRetries).add("minSleepTime", (Object)this.minBackoffDelay).add("maxSleepTime", (Object)this.maxBackoffDelay).add("scaleFactor", this.backoffScaleFactor).add("maxRetryTime", (Object)this.maxRetryTime).add("exceptionClassifier", (Object)this.exceptionClassifier).toString();
    }
}

