/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.$internal.io.netty.channel;

import com.datastax.driver.$internal.io.netty.channel.Channel;
import com.datastax.driver.$internal.io.netty.channel.ChannelFuture;
import com.datastax.driver.$internal.io.netty.channel.ChannelPromise;
import com.datastax.driver.$internal.io.netty.channel.EventLoop;
import com.datastax.driver.$internal.io.netty.channel.EventLoopGroup;
import com.datastax.driver.$internal.io.netty.util.NettyRuntime;
import com.datastax.driver.$internal.io.netty.util.concurrent.DefaultThreadFactory;
import com.datastax.driver.$internal.io.netty.util.concurrent.MultithreadEventExecutorGroup;
import com.datastax.driver.$internal.io.netty.util.internal.SystemPropertyUtil;
import com.datastax.driver.$internal.io.netty.util.internal.logging.InternalLogger;
import com.datastax.driver.$internal.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ThreadFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("com.datastax.driver.$internal.io.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

