/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.$internal.io.netty.handler.ipfilter;

import com.datastax.driver.$internal.io.netty.channel.ChannelFuture;
import com.datastax.driver.$internal.io.netty.channel.ChannelFutureListener;
import com.datastax.driver.$internal.io.netty.channel.ChannelHandler;
import com.datastax.driver.$internal.io.netty.channel.ChannelHandlerContext;
import com.datastax.driver.$internal.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import com.datastax.driver.$internal.io.netty.util.internal.ConcurrentSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;

@ChannelHandler.Sharable
public class UniqueIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final Set<InetAddress> connected = new ConcurrentSet<InetAddress>();

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        final InetAddress remoteIp = remoteAddress.getAddress();
        if (this.connected.contains(remoteIp)) {
            return false;
        }
        this.connected.add(remoteIp);
        ctx.channel().closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                UniqueIpFilter.this.connected.remove(remoteIp);
            }
        });
        return true;
    }
}

