/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.$internal.com.google.common.collect.ImmutableMap;
import com.datastax.driver.$internal.com.google.common.collect.Iterators;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeClassNameParser;
import com.datastax.driver.core.DataTypeCqlNameParser;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UserType
extends DataType
implements Iterable<Field> {
    static final String TYPE_NAME = "type_name";
    private static final String COLS_NAMES = "field_names";
    static final String COLS_TYPES = "field_types";
    private final String keyspace;
    private final String typeName;
    private final boolean frozen;
    private final ProtocolVersion protocolVersion;
    private volatile CodecRegistry codecRegistry;
    final Field[] byIdx;
    final Map<String, int[]> byName;

    private UserType(DataType.Name name, String keyspace, String typeName, boolean frozen, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, Field[] byIdx, Map<String, int[]> byName) {
        super(name);
        this.keyspace = keyspace;
        this.typeName = typeName;
        this.frozen = frozen;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.byIdx = byIdx;
        this.byName = byName;
    }

    UserType(String keyspace, String typeName, boolean frozen, Collection<Field> fields, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this(DataType.Name.UDT, keyspace, typeName, frozen, protocolVersion, codecRegistry, fields.toArray(new Field[fields.size()]), UserType.mapByName(fields));
    }

    private static ImmutableMap<String, int[]> mapByName(Collection<Field> fields) {
        ImmutableMap.Builder<String, int[]> builder = new ImmutableMap.Builder<String, int[]>();
        int i = 0;
        for (Field field : fields) {
            builder.put(field.getName(), new int[]{i++});
        }
        return builder.build();
    }

    static UserType build(KeyspaceMetadata ksm, Row row, VersionNumber version, Cluster cluster, Map<String, UserType> userTypes) {
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        String keyspace = row.getString("keyspace_name");
        String name = row.getString(TYPE_NAME);
        List<String> fieldNames = row.getList(COLS_NAMES, String.class);
        List<String> fieldTypes = row.getList(COLS_TYPES, String.class);
        ArrayList<Field> fields = new ArrayList<Field>(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            DataType fieldType = (double)version.getMajor() >= 3.0 ? DataTypeCqlNameParser.parse(fieldTypes.get(i), cluster, ksm.getName(), userTypes, ksm.userTypes, false, false) : DataTypeClassNameParser.parseOne(fieldTypes.get(i), protocolVersion, codecRegistry);
            fields.add(new Field(fieldNames.get(i), fieldType));
        }
        return new UserType(keyspace, name, false, fields, protocolVersion, codecRegistry);
    }

    public UDTValue newValue() {
        return new UDTValue(this);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int size() {
        return this.byIdx.length;
    }

    public boolean contains(String name) {
        return this.byName.containsKey(Metadata.handleId(name));
    }

    @Override
    public Iterator<Field> iterator() {
        return Iterators.forArray(this.byIdx);
    }

    public Collection<String> getFieldNames() {
        return this.byName.keySet();
    }

    public DataType getFieldType(String name) {
        int[] idx = this.byName.get(Metadata.handleId(name));
        if (idx == null) {
            throw new IllegalArgumentException(name + " is not a field defined in this definition");
        }
        return this.byIdx[idx[0]].getType();
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    public UserType copy(boolean newFrozen) {
        if (newFrozen == this.frozen) {
            return this;
        }
        return new UserType(this.name, this.keyspace, this.typeName, newFrozen, this.protocolVersion, this.codecRegistry, this.byIdx, this.byName);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.keyspace.hashCode();
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + Arrays.hashCode(this.byIdx);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)o;
        return this.name.equals((Object)other.name) && this.keyspace.equals(other.keyspace) && this.typeName.equals(other.typeName) && Arrays.equals(this.byIdx, other.byIdx);
    }

    public String exportAsString() {
        return this.asCQLQuery(true);
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    void setCodecRegistry(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TYPE ").append(Metadata.quoteIfNecessary(this.keyspace)).append('.').append(Metadata.quoteIfNecessary(this.typeName)).append(" (");
        if (formatted) {
            TableMetadata.spaceOrNewLine(sb, true);
        }
        for (int i = 0; i < this.byIdx.length; ++i) {
            sb.append(this.byIdx[i]);
            if (i < this.byIdx.length - 1) {
                sb.append(',');
                TableMetadata.spaceOrNewLine(sb, formatted);
                continue;
            }
            TableMetadata.newLine(sb, formatted);
        }
        return sb.append(");").toString();
    }

    public String toString() {
        String str = Metadata.quoteIfNecessary(this.getKeyspace()) + "." + Metadata.quoteIfNecessary(this.getTypeName());
        return this.isFrozen() ? "frozen<" + str + ">" : str;
    }

    @Override
    public String asFunctionParameterString() {
        return Metadata.quoteIfNecessary(this.getTypeName());
    }

    static class Shallow
    extends DataType {
        final String keyspaceName;
        final String typeName;
        final boolean frozen;

        Shallow(String keyspaceName, String typeName, boolean frozen) {
            super(DataType.Name.UDT);
            this.keyspaceName = keyspaceName;
            this.typeName = typeName;
            this.frozen = frozen;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }
    }

    public static class Field {
        private final String name;
        private final DataType type;

        Field(String name, DataType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.type});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }

        public String toString() {
            return Metadata.quoteIfNecessary(this.name) + ' ' + this.type;
        }
    }
}

