/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.$internal.com.google.common.base.Preconditions;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Insert
extends BuiltStatement {
    private final String table;
    private final List<Object> names = new ArrayList<Object>();
    private final List<Object> values = new ArrayList<Object>();
    private final Options usings;
    private boolean ifNotExists;
    private Object json;
    private JsonDefault jsonDefault;

    Insert(String keyspace, String table) {
        this(keyspace, table, null, null);
    }

    Insert(TableMetadata table) {
        this(Metadata.quoteIfNecessary(table.getKeyspace().getName()), Metadata.quoteIfNecessary(table.getName()), Arrays.asList(new Object[table.getPartitionKey().size()]), table.getPartitionKey());
    }

    Insert(String keyspace, String table, List<Object> routingKeyValues, List<ColumnMetadata> partitionKey) {
        super(keyspace, partitionKey, routingKeyValues);
        this.table = table;
        this.usings = new Options(this);
    }

    @Override
    StringBuilder buildQueryString(List<Object> variables, CodecRegistry codecRegistry) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        builder.append(" ");
        if (this.json != null) {
            builder.append("JSON ");
            Utils.appendValue(this.json, codecRegistry, builder, variables);
            if (this.jsonDefault == JsonDefault.UNSET) {
                builder.append(" DEFAULT UNSET");
            } else if (this.jsonDefault == JsonDefault.NULL) {
                builder.append(" DEFAULT NULL");
            }
        } else {
            builder.append("(");
            Utils.joinAndAppendNames(builder, codecRegistry, this.names);
            builder.append(") VALUES (");
            Utils.joinAndAppendValues(builder, codecRegistry, this.values, variables);
            builder.append(')');
        }
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.usings.usings, variables);
        }
        return builder;
    }

    public Insert value(String name, Object value) {
        Preconditions.checkState(this.json == null && this.jsonDefault == null, "Cannot mix INSERT JSON syntax with regular INSERT syntax");
        this.names.add(name);
        this.values.add(value);
        this.checkForBindMarkers(value);
        if (!this.hasNonIdempotentOps() && !Utils.isIdempotent(value)) {
            this.setNonIdempotentOps();
        }
        this.maybeAddRoutingKey(name, value);
        return this;
    }

    public Insert values(String[] names, Object[] values) {
        return this.values(Arrays.asList(names), Arrays.asList(values));
    }

    public Insert values(List<String> names, List<Object> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("Got %d names but %d values", names.size(), values.size()));
        }
        Preconditions.checkState(this.json == null && this.jsonDefault == null, "Cannot mix INSERT JSON syntax with regular INSERT syntax");
        this.names.addAll(names);
        this.values.addAll(values);
        for (int i = 0; i < names.size(); ++i) {
            Object value = values.get(i);
            this.checkForBindMarkers(value);
            this.maybeAddRoutingKey(names.get(i), value);
            if (this.hasNonIdempotentOps() || Utils.isIdempotent(value)) continue;
            this.setNonIdempotentOps();
        }
        return this;
    }

    public Insert json(Object json) {
        Preconditions.checkState(this.values.isEmpty() && this.names.isEmpty(), "Cannot mix INSERT JSON syntax with regular INSERT syntax");
        this.json = json;
        return this;
    }

    public Insert defaultUnset() {
        Preconditions.checkState(this.values.isEmpty() && this.names.isEmpty(), "Cannot mix INSERT JSON syntax with regular INSERT syntax");
        this.jsonDefault = JsonDefault.UNSET;
        return this;
    }

    public Insert defaultNull() {
        Preconditions.checkState(this.values.isEmpty() && this.names.isEmpty(), "Cannot mix INSERT JSON syntax with regular INSERT syntax");
        this.jsonDefault = JsonDefault.NULL;
        return this;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public Options using() {
        return this.usings;
    }

    public Insert ifNotExists() {
        this.setNonIdempotentOps();
        this.ifNotExists = true;
        return this;
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Insert> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Insert st) {
            super(st);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.checkForBindMarkers(using);
            return this;
        }

        public Insert value(String name, Object value) {
            return ((Insert)this.statement).value(name, value);
        }

        public Insert values(String[] names, Object[] values) {
            return ((Insert)this.statement).values(names, values);
        }
    }

    private static enum JsonDefault {
        NULL,
        UNSET;

    }
}

