/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.statement.StatementContext;

public class ObjectArgument
implements Argument {
    private final Object value;
    private final Integer sqlType;

    public ObjectArgument(Object value, Integer sqlType) {
        this.sqlType = sqlType;
        this.value = value;
        if (sqlType == null && value == null) {
            throw new IllegalArgumentException("Null value provided without a type");
        }
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value == null) {
            statement.setNull(position, this.sqlType);
        } else if (this.sqlType == null) {
            statement.setObject(position, this.value);
        } else {
            statement.setObject(position, this.value, this.sqlType);
        }
    }

    public String toString() {
        return (this.value == null ? "NULL" : String.valueOf(this.value)) + (this.sqlType == null ? "" : " (type " + this.sqlType + ")");
    }
}

