/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PostScript {
    public static final Slice MAGIC = Slices.utf8Slice((String)"ORC");
    private final List<Integer> version;
    private final long footerLength;
    private final long metadataLength;
    private final CompressionKind compression;
    private final long compressionBlockSize;
    private final HiveWriterVersion hiveWriterVersion;
    private final OptionalInt dwrfStripeCacheLength;
    private final Optional<DwrfStripeCacheMode> dwrfStripeCacheMode;

    public PostScript(List<Integer> version, long footerLength, long metadataLength, CompressionKind compression, long compressionBlockSize, HiveWriterVersion hiveWriterVersion, OptionalInt dwrfStripeCacheLength, Optional<DwrfStripeCacheMode> dwrfStripeCacheMode) {
        this.version = ImmutableList.copyOf((Collection)Objects.requireNonNull(version, "version is null"));
        this.footerLength = footerLength;
        this.metadataLength = metadataLength;
        this.compression = Objects.requireNonNull(compression, "compressionKind is null");
        this.compressionBlockSize = compressionBlockSize;
        this.hiveWriterVersion = Objects.requireNonNull(hiveWriterVersion, "hiveWriterVersion is null");
        this.dwrfStripeCacheLength = Objects.requireNonNull(dwrfStripeCacheLength, "dwrfStripeCacheLength is null");
        this.dwrfStripeCacheMode = Objects.requireNonNull(dwrfStripeCacheMode, "dwrfStripeCacheMode is null");
    }

    public List<Integer> getVersion() {
        return this.version;
    }

    public long getFooterLength() {
        return this.footerLength;
    }

    public long getMetadataLength() {
        return this.metadataLength;
    }

    public CompressionKind getCompression() {
        return this.compression;
    }

    public long getCompressionBlockSize() {
        return this.compressionBlockSize;
    }

    public HiveWriterVersion getHiveWriterVersion() {
        return this.hiveWriterVersion;
    }

    public OptionalInt getDwrfStripeCacheLength() {
        return this.dwrfStripeCacheLength;
    }

    public Optional<DwrfStripeCacheMode> getDwrfStripeCacheMode() {
        return this.dwrfStripeCacheMode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("footerLength", this.footerLength).add("metadataLength", this.metadataLength).add("compressionKind", (Object)this.compression).add("compressionBlockSize", this.compressionBlockSize).add("hiveWriterVersion", (Object)this.hiveWriterVersion).add("dwrfStripeCacheLength", (Object)this.dwrfStripeCacheLength).add("dwrfStripeCacheMode", this.dwrfStripeCacheMode).toString();
    }

    public static enum HiveWriterVersion {
        ORIGINAL(0),
        ORC_HIVE_8732(1);

        private final int orcWriterVersion;

        private HiveWriterVersion(int orcWriterVersion) {
            this.orcWriterVersion = orcWriterVersion;
        }

        public int getOrcWriterVersion() {
            return this.orcWriterVersion;
        }
    }
}

