/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class InMapOutputStream
extends BooleanOutputStream {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(InMapOutputStream.class).instanceSize();

    public InMapOutputStream(ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor) {
        super(columnWriterOptions, dwrfEncryptor);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column, int sequence) {
        return super.getStreamDataOutput(column, sequence, Stream.StreamKind.IN_MAP);
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + super.getRetainedBytes();
    }
}

