/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class MapFlatColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapFlatColumnWriter.class).instanceSize();
    private final int column;
    private final boolean compressed;
    private final ColumnEncoding columnEncoding;
    private final CompressedMetadataWriter metadataWriter;
    private boolean closed;

    public MapFlatColumnWriter(int column, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        this.column = column;
        this.compressed = columnWriterOptions.getCompressionKind() != CompressionKind.NONE;
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DWRF_MAP_FLAT, 0);
        this.metadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
    }

    @Override
    public List<ColumnWriter> getNestedColumnWriters() {
        return ImmutableList.of();
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        ImmutableMap.Builder encodings = ImmutableMap.builder();
        encodings.put((Object)this.column, (Object)this.columnEncoding);
        return encodings.build();
    }

    @Override
    public void beginRowGroup() {
    }

    @Override
    public long writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        return this.writeColumnarMap(columnarMap);
    }

    private long writeColumnarMap(ColumnarMap columnarMap) {
        return 0L;
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return ImmutableMap.of();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of();
    }

    @Override
    public List<StreamDataOutput> getIndexStreams() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.of();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.of();
    }

    @Override
    public long getBufferedBytes() {
        return 0L;
    }

    @Override
    public long getRetainedBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public void reset() {
        this.closed = false;
    }
}

