/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.SleepingRetry;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.concurrent.ThreadLocalRandom;

@NotThreadSafe
public class ExponentialBackoffRetry
extends SleepingRetry {
    private final int mBaseSleepTimeMs;
    private final int mMaxSleepMs;

    public ExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepMs, int maxRetries) {
        super(maxRetries);
        Preconditions.checkArgument(baseSleepTimeMs >= 0, "Base must be a positive number, or 0");
        Preconditions.checkArgument(maxSleepMs >= 0, "Max must be a positive number, or 0");
        this.mBaseSleepTimeMs = baseSleepTimeMs;
        this.mMaxSleepMs = maxSleepMs;
    }

    @Override
    protected long getSleepTime() {
        int count = this.getAttemptCount();
        if (count >= 30) {
            return this.mMaxSleepMs;
        }
        int sleepMs = this.mBaseSleepTimeMs * ThreadLocalRandom.current().nextInt(1 << count, 1 << count + 1);
        return Math.min(ExponentialBackoffRetry.abs(sleepMs, this.mMaxSleepMs), this.mMaxSleepMs);
    }

    private static int abs(int value, int defaultValue) {
        int result = Math.abs(value);
        if (result == Integer.MIN_VALUE) {
            result = defaultValue;
        }
        return result;
    }
}

