/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class ThriftIndexHandle
implements ConnectorIndexHandle {
    private final SchemaTableName schemaTableName;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final Optional<ConnectorSession> session;

    public ThriftIndexHandle(SchemaTableName schemaTableName, TupleDomain<ColumnHandle> tupleDomain, ConnectorSession session) {
        this(schemaTableName, tupleDomain, Optional.of(Objects.requireNonNull(session, "session is null")));
    }

    @JsonCreator
    public ThriftIndexHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain) {
        this(schemaTableName, tupleDomain, Optional.empty());
    }

    private ThriftIndexHandle(SchemaTableName schemaTableName, TupleDomain<ColumnHandle> tupleDomain, Optional<ConnectorSession> session) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftIndexHandle other = (ThriftIndexHandle)obj;
        return Objects.equals(this.schemaTableName, other.schemaTableName) && Objects.equals(this.tupleDomain, other.tupleDomain);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.tupleDomain);
    }

    public String toString() {
        return this.schemaTableName.toString() + this.session.map(value -> ", constraint = " + this.tupleDomain.toString(value.getSqlFunctionProperties())).orElse("");
    }
}

