/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.drift.client.ExceptionClassification;
import com.facebook.drift.client.guice.DriftClientBinder;
import com.facebook.presto.connector.thrift.ThriftConnector;
import com.facebook.presto.connector.thrift.ThriftConnectorConfig;
import com.facebook.presto.connector.thrift.ThriftConnectorStats;
import com.facebook.presto.connector.thrift.ThriftIndexProvider;
import com.facebook.presto.connector.thrift.ThriftMetadata;
import com.facebook.presto.connector.thrift.ThriftPageSourceProvider;
import com.facebook.presto.connector.thrift.ThriftSessionProperties;
import com.facebook.presto.connector.thrift.ThriftSplitManager;
import com.facebook.presto.connector.thrift.annotations.ForMetadataRefresh;
import com.facebook.presto.thrift.api.connector.PrestoThriftService;
import com.facebook.presto.thrift.api.connector.PrestoThriftServiceException;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftModule
implements Module {
    private final String connectorId;

    public ThriftModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public void configure(Binder binder) {
        DriftClientBinder.driftClientBinder((Binder)binder).bindDriftClient(PrestoThriftService.class).withExceptionClassifier(t -> {
            if (t instanceof PrestoThriftServiceException) {
                boolean retryable = ((PrestoThriftServiceException)t).isRetryable();
                return new ExceptionClassification(Optional.of(retryable), ExceptionClassification.HostStatus.NORMAL);
            }
            return ExceptionClassification.NORMAL_EXCEPTION;
        });
        binder.bind(ThriftConnector.class).in(Scopes.SINGLETON);
        binder.bind(ThriftMetadata.class).in(Scopes.SINGLETON);
        binder.bind(ThriftSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ThriftPageSourceProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ThriftConnectorConfig.class);
        binder.bind(ThriftSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(ThriftIndexProvider.class).in(Scopes.SINGLETON);
        binder.bind(ThriftConnectorStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ThriftConnectorStats.class).as(ObjectNames.generatedNameOf(ThriftConnectorStats.class, (String)this.connectorId));
    }

    @Provides
    @Singleton
    @ForMetadataRefresh
    public Executor createMetadataRefreshExecutor(ThriftConnectorConfig config) {
        return Executors.newFixedThreadPool(config.getMetadataRefreshThreads(), Threads.daemonThreadsNamed((String)"metadata-refresh-%s"));
    }
}

