/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.presto.connector.thrift.ThriftConnectorConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public final class ThriftSessionProperties {
    private static final String SET_THRIFT_IDENTITY_HEADER = "use_thrift_identity_header";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public ThriftSessionProperties(ThriftConnectorConfig config) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)SET_THRIFT_IDENTITY_HEADER, (String)"Thrift identity is used when set to true", (Boolean)config.getUseIdentityThriftHeader(), (boolean)false));
    }

    public static boolean isUseIdentityThriftHeader(ConnectorSession session) {
        return (Boolean)session.getProperty(SET_THRIFT_IDENTITY_HEADER, Boolean.class);
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

