/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class HiveTransactionManager {
    private final ConcurrentMap<ConnectorTransactionHandle, TransactionalMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, TransactionalMetadata>();

    @Inject
    public HiveTransactionManager() {
    }

    public TransactionalMetadata get(ConnectorTransactionHandle transactionHandle) {
        return (TransactionalMetadata)this.transactions.get(transactionHandle);
    }

    public TransactionalMetadata remove(ConnectorTransactionHandle transactionHandle) {
        return (TransactionalMetadata)this.transactions.remove(transactionHandle);
    }

    public void put(ConnectorTransactionHandle transactionHandle, TransactionalMetadata metadata) {
        ConnectorMetadata previousValue = this.transactions.putIfAbsent(transactionHandle, metadata);
        Preconditions.checkState((previousValue == null ? 1 : 0) != 0);
    }
}

