/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.writer.StreamLayoutFactory;
import io.airlift.units.DataSize;
import java.util.OptionalInt;
import javax.validation.constraints.NotNull;

public class OrcFileWriterConfig {
    public static final int DEFAULT_COMPRESSION_LEVEL = Integer.MIN_VALUE;
    private DataSize stripeMinSize = DefaultOrcWriterFlushPolicy.DEFAULT_STRIPE_MIN_SIZE;
    private DataSize stripeMaxSize = DefaultOrcWriterFlushPolicy.DEFAULT_STRIPE_MAX_SIZE;
    private int stripeMaxRowCount = 10000000;
    private int rowGroupMaxRowCount = 10000;
    private DataSize dictionaryMaxMemory = OrcWriterOptions.DEFAULT_DICTIONARY_MAX_MEMORY;
    private DataSize stringStatisticsLimit = OrcWriterOptions.DEFAULT_MAX_STRING_STATISTICS_LIMIT;
    private DataSize maxCompressionBufferSize = OrcWriterOptions.DEFAULT_MAX_COMPRESSION_BUFFER_SIZE;
    private StreamLayoutType streamLayoutType = StreamLayoutType.BY_COLUMN_SIZE;
    private boolean isDwrfStripeCacheEnabled;
    private DataSize dwrfStripeCacheMaxSize = OrcWriterOptions.DEFAULT_DWRF_STRIPE_CACHE_MAX_SIZE;
    private DwrfStripeCacheMode dwrfStripeCacheMode = OrcWriterOptions.DEFAULT_DWRF_STRIPE_CACHE_MODE;
    private int compressionLevel = Integer.MIN_VALUE;

    public OrcWriterOptions.Builder toOrcWriterOptionsBuilder() {
        DefaultOrcWriterFlushPolicy flushPolicy = DefaultOrcWriterFlushPolicy.builder().withStripeMinSize(this.stripeMinSize).withStripeMaxSize(this.stripeMaxSize).withStripeMaxRowCount(this.stripeMaxRowCount).build();
        OptionalInt resolvedCompressionLevel = OptionalInt.empty();
        if (this.compressionLevel != Integer.MIN_VALUE) {
            resolvedCompressionLevel = OptionalInt.of(this.compressionLevel);
        }
        return OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)flushPolicy).withRowGroupMaxRowCount(this.rowGroupMaxRowCount).withDictionaryMaxMemory(this.dictionaryMaxMemory).withMaxStringStatisticsLimit(this.stringStatisticsLimit).withMaxCompressionBufferSize(this.maxCompressionBufferSize).withStreamLayoutFactory(OrcFileWriterConfig.getStreamLayoutFactory(this.streamLayoutType)).withDwrfStripeCacheEnabled(this.isDwrfStripeCacheEnabled).withDwrfStripeCacheMaxSize(this.dwrfStripeCacheMaxSize).withDwrfStripeCacheMode(this.dwrfStripeCacheMode).withCompressionLevel(resolvedCompressionLevel);
    }

    @NotNull
    public DataSize getStripeMinSize() {
        return this.stripeMinSize;
    }

    @Config(value="hive.orc.writer.stripe-min-size")
    public OrcFileWriterConfig setStripeMinSize(DataSize stripeMinSize) {
        this.stripeMinSize = stripeMinSize;
        return this;
    }

    @NotNull
    public DataSize getStripeMaxSize() {
        return this.stripeMaxSize;
    }

    @Config(value="hive.orc.writer.stripe-max-size")
    public OrcFileWriterConfig setStripeMaxSize(DataSize stripeMaxSize) {
        this.stripeMaxSize = stripeMaxSize;
        return this;
    }

    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    @Config(value="hive.orc.writer.stripe-max-rows")
    public OrcFileWriterConfig setStripeMaxRowCount(int stripeMaxRowCount) {
        this.stripeMaxRowCount = stripeMaxRowCount;
        return this;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    @Config(value="hive.orc.writer.row-group-max-rows")
    public OrcFileWriterConfig setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        return this;
    }

    @NotNull
    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    @Config(value="hive.orc.writer.dictionary-max-memory")
    public OrcFileWriterConfig setDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        this.dictionaryMaxMemory = dictionaryMaxMemory;
        return this;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    @Config(value="hive.orc.writer.compression-level")
    public OrcFileWriterConfig setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    @NotNull
    public DataSize getStringStatisticsLimit() {
        return this.stringStatisticsLimit;
    }

    @Config(value="hive.orc.writer.string-statistics-limit")
    public OrcFileWriterConfig setStringStatisticsLimit(DataSize stringStatisticsLimit) {
        this.stringStatisticsLimit = stringStatisticsLimit;
        return this;
    }

    @NotNull
    public DataSize getMaxCompressionBufferSize() {
        return this.maxCompressionBufferSize;
    }

    @Config(value="hive.orc.writer.max-compression-buffer-size")
    public OrcFileWriterConfig setMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
        this.maxCompressionBufferSize = maxCompressionBufferSize;
        return this;
    }

    @NotNull
    public StreamLayoutType getStreamLayoutType() {
        return this.streamLayoutType;
    }

    @Config(value="hive.orc.writer.stream-layout-type")
    public OrcFileWriterConfig setStreamLayoutType(StreamLayoutType streamLayoutType) {
        this.streamLayoutType = streamLayoutType;
        return this;
    }

    public boolean isDwrfStripeCacheEnabled() {
        return this.isDwrfStripeCacheEnabled;
    }

    @Config(value="hive.orc.writer.dwrf-stripe-cache-enabled")
    public OrcFileWriterConfig setDwrfStripeCacheEnabled(boolean isDwrfStripeCacheEnabled) {
        this.isDwrfStripeCacheEnabled = isDwrfStripeCacheEnabled;
        return this;
    }

    @NotNull
    public DataSize getDwrfStripeCacheMaxSize() {
        return this.dwrfStripeCacheMaxSize;
    }

    @Config(value="hive.orc.writer.dwrf-stripe-cache-max-size")
    public OrcFileWriterConfig setDwrfStripeCacheMaxSize(DataSize dwrfStripeCacheMaxSize) {
        this.dwrfStripeCacheMaxSize = dwrfStripeCacheMaxSize;
        return this;
    }

    @NotNull
    public DwrfStripeCacheMode getDwrfStripeCacheMode() {
        return this.dwrfStripeCacheMode;
    }

    @Config(value="hive.orc.writer.dwrf-stripe-cache-mode")
    public OrcFileWriterConfig setDwrfStripeCacheMode(DwrfStripeCacheMode dwrfStripeCacheMode) {
        this.dwrfStripeCacheMode = dwrfStripeCacheMode;
        return this;
    }

    private static StreamLayoutFactory getStreamLayoutFactory(StreamLayoutType type) {
        switch (type) {
            case BY_COLUMN_SIZE: {
                return new StreamLayoutFactory.ColumnSizeLayoutFactory();
            }
            case BY_STREAM_SIZE: {
                return new StreamLayoutFactory.StreamSizeLayoutFactory();
            }
        }
        throw new RuntimeException("Unrecognized type " + (Object)((Object)type));
    }

    public static enum StreamLayoutType {
        BY_STREAM_SIZE,
        BY_COLUMN_SIZE;

    }
}

