/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.GenericHiveRecordCursor;
import com.facebook.presto.hive.HiveColumnHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;

class S3SelectRecordCursor<K, V extends Writable>
extends GenericHiveRecordCursor<K, V> {
    private static final String THRIFT_STRUCT = "struct";
    private static final String START_STRUCT = "{";
    private static final String END_STRUCT = "}";
    private static final String FIELD_SEPARATOR = ",";

    public S3SelectRecordCursor(Configuration configuration, Path path, RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        super(configuration, path, recordReader, totalBytes, S3SelectRecordCursor.updateSplitSchema(splitSchema, columns), columns, hiveStorageTimeZone, typeManager);
    }

    static Properties updateSplitSchema(Properties splitSchema, List<HiveColumnHandle> columns) {
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        Properties updatedSchema = new Properties();
        updatedSchema.putAll((Map<?, ?>)splitSchema);
        updatedSchema.setProperty("columns", S3SelectRecordCursor.buildColumns(columns));
        updatedSchema.setProperty("columns.types", S3SelectRecordCursor.buildColumnTypes(columns));
        ThriftTable thriftTable = S3SelectRecordCursor.parseThriftDdl(splitSchema.getProperty("serialization.ddl"));
        updatedSchema.setProperty("serialization.ddl", S3SelectRecordCursor.thriftTableToDdl(S3SelectRecordCursor.pruneThriftTable(thriftTable, columns)));
        return updatedSchema;
    }

    private static String buildColumns(List<HiveColumnHandle> columns) {
        if (columns == null || columns.isEmpty()) {
            return "";
        }
        return columns.stream().map(HiveColumnHandle::getName).collect(Collectors.joining(FIELD_SEPARATOR));
    }

    private static String buildColumnTypes(List<HiveColumnHandle> columns) {
        if (columns == null || columns.isEmpty()) {
            return "";
        }
        return columns.stream().map(column -> column.getHiveType().getTypeInfo().getTypeName()).collect(Collectors.joining(FIELD_SEPARATOR));
    }

    private static ThriftTable parseThriftDdl(String ddl) {
        if (Strings.isNullOrEmpty((String)ddl)) {
            return null;
        }
        String[] parts = ddl.trim().split("\\s+");
        Preconditions.checkArgument((parts.length >= 5 ? 1 : 0) != 0, (Object)("Invalid Thrift DDL " + ddl));
        Preconditions.checkArgument((boolean)THRIFT_STRUCT.equals(parts[0]), (Object)"Thrift DDL should start with struct");
        ThriftTable thriftTable = new ThriftTable();
        thriftTable.setTableName(parts[1]);
        Preconditions.checkArgument((boolean)START_STRUCT.equals(parts[2]), (Object)("Invalid Thrift DDL " + ddl));
        Preconditions.checkArgument((boolean)parts[parts.length - 1].endsWith(END_STRUCT), (Object)("Invalid Thrift DDL " + ddl));
        String lastColumnNameWithEndStruct = parts[parts.length - 1];
        parts[parts.length - 1] = lastColumnNameWithEndStruct.substring(0, lastColumnNameWithEndStruct.length() - 1);
        ArrayList<ThriftField> fields = new ArrayList<ThriftField>();
        for (int i = 3; i < parts.length - 1; i += 2) {
            ThriftField thriftField = new ThriftField();
            thriftField.setType(parts[i]);
            String columnNameWithFieldSeparator = parts[i + 1];
            if (columnNameWithFieldSeparator.endsWith(FIELD_SEPARATOR)) {
                parts[i + 1] = columnNameWithFieldSeparator.substring(0, columnNameWithFieldSeparator.length() - 1);
            }
            thriftField.setName(parts[i + 1]);
            fields.add(thriftField);
        }
        thriftTable.setFields(fields);
        return thriftTable;
    }

    private static ThriftTable pruneThriftTable(ThriftTable thriftTable, List<HiveColumnHandle> columns) {
        if (thriftTable == null) {
            return null;
        }
        List fields = thriftTable.getFields();
        if (fields == null || fields.isEmpty()) {
            return thriftTable;
        }
        Set columnNames = (Set)columns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        List filteredFields = fields.stream().filter(field -> columnNames.contains(((ThriftField)field).getName())).collect(Collectors.toList());
        thriftTable.setFields(filteredFields);
        return thriftTable;
    }

    private static String thriftTableToDdl(ThriftTable thriftTable) {
        if (thriftTable == null) {
            return "";
        }
        List fields = thriftTable.getFields();
        if (fields == null || fields.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(THRIFT_STRUCT).append(" ").append(thriftTable.getTableName()).append(" ").append(START_STRUCT);
        stringBuilder.append(fields.stream().map(field -> " " + ((ThriftField)field).getType() + " " + ((ThriftField)field).getName()).collect(Collectors.joining(FIELD_SEPARATOR)));
        stringBuilder.append(END_STRUCT);
        return stringBuilder.toString();
    }

    private static class ThriftTable {
        private String tableName;
        private List<ThriftField> fields;

        private ThriftTable() {
        }

        private String getTableName() {
            return this.tableName;
        }

        private void setTableName(String tableName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or empty string");
            this.tableName = tableName;
        }

        private List<ThriftField> getFields() {
            return this.fields;
        }

        private void setFields(List<ThriftField> fields) {
            Objects.requireNonNull(fields, "fields is null");
            this.fields = fields;
        }
    }

    private static class ThriftField {
        private String type;
        private String name;

        private ThriftField() {
        }

        private String getType() {
            return this.type;
        }

        private void setType(String type) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type is null or empty string");
            this.type = type;
        }

        private String getName() {
            return this.name;
        }

        private void setName(String name) {
            Objects.requireNonNull(name, "name is null");
            this.name = name;
        }
    }
}

