/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.authentication;

import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.authentication.HadoopAuthentication;
import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.facebook.presto.hive.authentication.MetastoreKerberosConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TTransport;

public class KerberosHiveMetastoreAuthentication
implements HiveMetastoreAuthentication {
    private static final Map<String, String> SASL_PROPERTIES = ImmutableMap.of((Object)"javax.security.sasl.qop", (Object)"auth", (Object)"javax.security.sasl.server.authentication", (Object)"true");
    private final String hiveMetastoreServicePrincipal;
    private final HadoopAuthentication authentication;
    private final boolean hdfsWireEncryptionEnabled;

    @Inject
    public KerberosHiveMetastoreAuthentication(MetastoreKerberosConfig config, @ForHiveMetastore HadoopAuthentication authentication, HiveClientConfig hiveClientConfig) {
        this(config.getHiveMetastoreServicePrincipal(), authentication, hiveClientConfig.isHdfsWireEncryptionEnabled());
    }

    public KerberosHiveMetastoreAuthentication(String hiveMetastoreServicePrincipal, HadoopAuthentication authentication, boolean hdfsWireEncryptionEnabled) {
        this.hiveMetastoreServicePrincipal = Objects.requireNonNull(hiveMetastoreServicePrincipal, "hiveMetastoreServicePrincipal is null");
        this.authentication = Objects.requireNonNull(authentication, "authentication is null");
        this.hdfsWireEncryptionEnabled = hdfsWireEncryptionEnabled;
    }

    public TTransport authenticate(TTransport rawTransport, String hiveMetastoreHost, Optional<String> tokenString) {
        return tokenString.map(s -> this.authenticateWithToken(rawTransport, (String)s)).orElseGet(() -> this.authenticateWithHost(rawTransport, hiveMetastoreHost));
    }

    private TTransport authenticateWithToken(TTransport rawTransport, String tokenString) {
        try {
            Token token = new Token();
            token.decodeFromUrlString(tokenString);
            TSaslClientTransport saslTransport = new TSaslClientTransport(SaslRpcServer.AuthMethod.TOKEN.getMechanismName(), null, null, "default", SASL_PROPERTIES, (CallbackHandler)new SaslClientCallbackHandler((Token<? extends TokenIdentifier>)token), rawTransport);
            return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private TTransport authenticateWithHost(TTransport rawTransport, String hiveMetastoreHost) {
        try {
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)this.hiveMetastoreServicePrincipal, (String)hiveMetastoreHost);
            String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
            Preconditions.checkState((names.length == 3 ? 1 : 0) != 0, (String)"Kerberos principal name does NOT have the expected hostname part: %s", (Object)serverPrincipal);
            ImmutableMap saslProps = ImmutableMap.of((Object)"javax.security.sasl.qop", (Object)(this.hdfsWireEncryptionEnabled ? "auth-conf" : "auth"), (Object)"javax.security.sasl.server.authentication", (Object)"true");
            TSaslClientTransport saslTransport = new TSaslClientTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), null, names[0], names[1], (Map)saslProps, null, rawTransport);
            return new TUGIAssumingTransport((TTransport)saslTransport, this.authentication.getUserGroupInformation());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
            this.userName = SaslClientCallbackHandler.encodeIdentifier(token.getIdentifier());
            this.userPassword = SaslClientCallbackHandler.encodePassword(token.getPassword());
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.userName);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword(this.userPassword);
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback realmCallback = (RealmCallback)callback;
                    realmCallback.setText(realmCallback.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
        }

        private static String encodeIdentifier(byte[] identifier) {
            return Base64.getEncoder().encodeToString(identifier);
        }

        private static char[] encodePassword(byte[] password) {
            return Base64.getEncoder().encodeToString(password).toCharArray();
        }
    }
}

