/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.util.SortBuffer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MergingPageIterator
extends AbstractIterator<Page> {
    private final List<Type> types;
    private final List<Integer> sortFields;
    private final List<SortOrder> sortOrders;
    private final PageBuilder pageBuilder;
    private final Iterator<PagePosition> pagePositions;

    public MergingPageIterator(Collection<Iterator<Page>> iterators, List<Type> types, List<Integer> sortFields, List<SortOrder> sortOrders) {
        Objects.requireNonNull(sortFields, "sortFields is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        Preconditions.checkArgument((sortFields.size() == sortOrders.size() ? 1 : 0) != 0, (Object)"sortFields and sortOrders size must match");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.sortFields = ImmutableList.copyOf(sortFields);
        this.sortOrders = ImmutableList.copyOf(sortOrders);
        this.pageBuilder = new PageBuilder(types);
        this.pagePositions = Iterators.mergeSorted((Iterable)iterators.stream().map(pages -> Iterators.concat((Iterator)Iterators.transform((Iterator)pages, x$0 -> new PagePositionIterator((Page)x$0)))).collect(Collectors.toList()), Comparator.naturalOrder());
    }

    protected Page computeNext() {
        while (!this.pageBuilder.isFull() && this.pagePositions.hasNext()) {
            this.pagePositions.next().appendTo(this.pageBuilder);
        }
        if (this.pageBuilder.isEmpty()) {
            return (Page)this.endOfData();
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private class PagePosition
    implements Comparable<PagePosition> {
        private final Page page;
        private final int position;

        public PagePosition(Page page, int position) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.position = position;
        }

        public void appendTo(PageBuilder pageBuilder) {
            SortBuffer.appendPositionTo(this.page, this.position, pageBuilder);
        }

        @Override
        public int compareTo(PagePosition other) {
            for (int i = 0; i < MergingPageIterator.this.sortFields.size(); ++i) {
                int result;
                int channel = (Integer)MergingPageIterator.this.sortFields.get(i);
                SortOrder order = (SortOrder)MergingPageIterator.this.sortOrders.get(i);
                Type type = (Type)MergingPageIterator.this.types.get(channel);
                Block block = this.page.getBlock(channel);
                Block otherBlock = other.page.getBlock(channel);
                try {
                    result = order.compareBlockValue(type, block, this.position, otherBlock, other.position);
                }
                catch (NotSupportedException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
                }
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    private class PagePositionIterator
    extends AbstractIterator<PagePosition> {
        private final Page page;
        private int position = -1;

        private PagePositionIterator(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        protected PagePosition computeNext() {
            ++this.position;
            if (this.position == this.page.getPositionCount()) {
                return (PagePosition)this.endOfData();
            }
            return new PagePosition(this.page, this.position);
        }
    }
}

