/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.block.LazyBlockLoader;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.segment.DruidSegmentReader;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public class DruidSegmentPageSource
implements ConnectorPageSource {
    private final DataInputSource dataInputSource;
    private final List<ColumnHandle> columns;
    private final DruidSegmentReader segmentReader;
    private int batchId;
    private boolean closed;
    private long completedBytes;
    private long completedPositions;

    public DruidSegmentPageSource(DataInputSource dataInputSource, List<ColumnHandle> columns, DruidSegmentReader segmentReader) {
        this.dataInputSource = Objects.requireNonNull(dataInputSource, "dataInputSource is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.segmentReader = Objects.requireNonNull(segmentReader, "segmentReader is null");
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.dataInputSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        ++this.batchId;
        int batchSize = this.segmentReader.nextBatch();
        if (batchSize <= 0) {
            this.close();
            return null;
        }
        Block[] blocks = new Block[this.columns.size()];
        for (int i = 0; i < blocks.length; ++i) {
            DruidColumnHandle columnHandle = (DruidColumnHandle)this.columns.get(i);
            blocks[i] = new LazyBlock(batchSize, (LazyBlockLoader)new SegmentBlockLoader(columnHandle.getColumnType(), columnHandle.getColumnName()));
        }
        Page page = new Page(batchSize, blocks);
        this.completedBytes += page.getSizeInBytes();
        this.completedPositions += (long)page.getPositionCount();
        return page;
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.closed = true;
    }

    private final class SegmentBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final Type type;
        private final String name;
        private boolean loaded;

        public SegmentBlockLoader(Type type, String name) {
            this.expectedBatchId = DruidSegmentPageSource.this.batchId;
            this.type = Objects.requireNonNull(type, "type is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState((DruidSegmentPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            Block block = DruidSegmentPageSource.this.segmentReader.readBlock(this.type, this.name);
            lazyBlock.setBlock(block);
            this.loaded = true;
        }
    }
}

