/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidQueryGenerator;
import com.facebook.presto.druid.metadata.DruidSegmentInfo;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DruidSplit
implements ConnectorSplit {
    private final SplitType splitType;
    private final Optional<DruidQueryGenerator.GeneratedDql> brokerDql;
    private final Optional<DruidSegmentInfo> segmentInfo;
    private final Optional<HostAddress> address;

    @JsonCreator
    public DruidSplit(@JsonProperty(value="splitType") SplitType splitType, @JsonProperty(value="brokerDql") Optional<DruidQueryGenerator.GeneratedDql> brokerDql, @JsonProperty(value="segmentInfo") Optional<DruidSegmentInfo> segmentInfo, @JsonProperty(value="address") Optional<HostAddress> address) {
        this.splitType = Objects.requireNonNull(splitType, "splitType id is null");
        this.brokerDql = Objects.requireNonNull(brokerDql, "brokerDql is null");
        this.segmentInfo = Objects.requireNonNull(segmentInfo, "segment info is null");
        this.address = Objects.requireNonNull(address, "address info is null");
        if (splitType == SplitType.SEGMENT) {
            Preconditions.checkArgument((boolean)segmentInfo.isPresent(), (Object)"SegmentInfo is missing from split");
            Preconditions.checkArgument((boolean)address.isPresent(), (Object)"Address is missing from split");
        } else {
            Preconditions.checkArgument((boolean)brokerDql.isPresent(), (Object)"brokerDql is missing from the split");
        }
    }

    public static DruidSplit createBrokerSplit(DruidQueryGenerator.GeneratedDql brokerDql) {
        return new DruidSplit(SplitType.BROKER, Optional.of(Objects.requireNonNull(brokerDql, "brokerDql is null")), Optional.empty(), Optional.empty());
    }

    public static DruidSplit createSegmentSplit(DruidSegmentInfo segmentInfo, HostAddress address) {
        return new DruidSplit(SplitType.SEGMENT, Optional.empty(), Optional.of(Objects.requireNonNull(segmentInfo, "segmentInfo are null")), Optional.of(Objects.requireNonNull(address, "address is null")));
    }

    @JsonProperty
    public SplitType getSplitType() {
        return this.splitType;
    }

    @JsonProperty
    public Optional<DruidQueryGenerator.GeneratedDql> getBrokerDql() {
        return this.brokerDql;
    }

    @JsonProperty
    public Optional<DruidSegmentInfo> getSegmentInfo() {
        return this.segmentInfo;
    }

    @JsonProperty
    public HostAddress getAddress() {
        return this.address.isPresent() ? this.address.get() : null;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return (List)this.address.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("splitType", (Object)this.splitType).add("brokerDql", this.brokerDql).add("segmentInfo", this.segmentInfo).add("address", this.address).toString();
    }

    public static enum SplitType {
        SEGMENT,
        BROKER;

    }
}

