/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.presto.druid.DruidQueryGenerator;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class DruidTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<DruidQueryGenerator.GeneratedDql> dql;

    @JsonCreator
    public DruidTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="dql") Optional<DruidQueryGenerator.GeneratedDql> dql) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.dql = Objects.requireNonNull(dql, "dql is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<DruidQueryGenerator.GeneratedDql> getDql() {
        return this.dql;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DruidTableHandle other = (DruidTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.dql, other.dql);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("dql", this.dql).toString();
    }

    public static DruidTableHandle fromSchemaTableName(SchemaTableName schemaTableName) {
        return new DruidTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName(), Optional.empty());
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }
}

