/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.authentication;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.druid.ForDruidClient;
import com.facebook.presto.druid.authentication.DruidBasicAuthHttpRequestFilter;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.function.Predicate;

public class DruidAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindAuthenticationModule(config -> config.getDruidAuthenticationType() == DruidConfig.DruidAuthenticationType.NONE, DruidAuthenticationModule.noneAuthenticationModule());
        this.bindAuthenticationModule(config -> config.getDruidAuthenticationType() == DruidConfig.DruidAuthenticationType.BASIC, DruidAuthenticationModule.basicAuthenticationModule());
        this.bindAuthenticationModule(config -> config.getDruidAuthenticationType() == DruidConfig.DruidAuthenticationType.KERBEROS, DruidAuthenticationModule.kerberosbAuthenticationModule());
    }

    private void bindAuthenticationModule(Predicate<DruidConfig> predicate, Module module) {
        this.install(ConditionalModule.installModuleIf(DruidConfig.class, predicate, (Module)module));
    }

    private static Module noneAuthenticationModule() {
        return binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("druid-client", ForDruidClient.class);
    }

    private static Module basicAuthenticationModule() {
        return binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("druid-client", ForDruidClient.class).withConfigDefaults(config -> config.setAuthenticationEnabled(false)).withFilter(DruidBasicAuthHttpRequestFilter.class);
    }

    private static Module kerberosbAuthenticationModule() {
        return binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("druid-client", ForDruidClient.class).withConfigDefaults(config -> config.setAuthenticationEnabled(true));
    }
}

